package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func GetFeaturedCarouselEntry(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	fceid := p.Get("fceid")
	if fceid == "" {
		return nil, protocol.ErrMissingParameter
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.GetFeaturedCarouselEntryRequest{
			ID: fceid,
		}

		resp, err := discoveryClient.GetFeaturedCarouselEntry(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryFeaturedCarouselEntryDocument(resp.GetFeaturedCarouselEntry())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.GetFeaturedCarouselEntry(ctx, fceid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
