package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func GetFeaturedCarousels(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	offset, limit, err := api.GetPagination(p)
	if err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.GetFeaturedCarouselsRequest{
			Offset: int32(offset),
			Limit:  int32(limit),
		}

		resp, err := discoveryClient.GetFeaturedCarousels(ctx, req)
		if err != nil {
			return nil, err
		}

		doc, err := protocol.FromDiscoveryFeaturedCaarousels(resp.GetFeaturedCarousels())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.GetFeaturedCarousels(ctx, offset, limit, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
