package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func GetFeaturedSchedule(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	fsid := p.Get("fsid")

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.GetFeaturedScheduleRequest{
			ScheduleID: fsid,
		}

		resp, err := discoveryClient.GetFeaturedSchedule(ctx, req)
		if err != nil {
			return nil, err
		}

		doc, err := protocol.FromDiscoveryFeaturedScheduleDocument(resp.GetFeaturedSchedule())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.GetFeaturedSchedule(ctx, fsid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
