package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func OrderCategory(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")

	var body documents.OrderCategoryRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.OrderCategoryRequest{
			CategoryID: cid,
			Extensions: body.Extensions,
		}

		resp, err := discoveryClient.OrderCategory(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryCategory(resp.GetCategory())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.OrderCategory(ctx, cid, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
