package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

func RemoveExtensionFromCategory(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("eid")
	cid := p.Get("cid")

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.RemoveExtensionFromCategoryRequest{
			CategoryID:  cid,
			ExtensionID: eid,
		}

		resp, err := discoveryClient.RemoveExtensionFromCategory(ctx, req)
		if err != nil {
			return nil, err
		}

		doc, err := protocol.FromDiscoveryCategoryMembership(resp.GetExtensionCategoryMembership())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.RemoveExtensionFromCategory(ctx, eid, cid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
