package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/twirputils"
	"code.justin.tv/extensions/orchestration/service/client"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/gds/gds/golibs/http"
	"code.justin.tv/gds/gds/golibs/params"
)

// UpdateExtensionVersionDiscoveryDataAPICall is a http.APICall adapter for update extension
// version discovery
func UpdateExtensionVersionDiscoveryDataAPICall(updateFunc func(context.Context, string, string, client.ExtensionDiscoveryDataInput) (*discovery.PutExtensionVersionDiscoveryDataResponse, error)) http.APICall {
	return http.APICall(func(ctx context.Context) (interface{}, error) {

		p := params.New(ctx)
		eid := p.Get("id")
		ver := p.Get("version")

		var req client.ExtensionDiscoveryDataInput
		if err := p.ParseJSONBody(&req); err != nil {
			return nil, err
		}

		return updateFunc(ctx, eid, ver, req)
	})
}

func UpdateExtensionVersionDiscoveryData(ctx context.Context, extensionID, version string, input client.ExtensionDiscoveryDataInput) (*discovery.PutExtensionVersionDiscoveryDataResponse, error) {

	req := &discovery.PutExtensionVersionDiscoveryDataRequest{
		UpdateData: &discovery.ExtensionVersionDiscoveryDataUpdate{
			ExtensionID:      extensionID,
			Version:          version,
			Name:             twirputils.WrapStringPointer(input.Name),
			AuthorName:       twirputils.WrapStringPointer(input.AuthorName),
			Description:      twirputils.WrapStringPointer(input.Description),
			EULATOSURL:       twirputils.WrapStringPointer(input.EULATOSURL),
			PrivacyPolicyURL: twirputils.WrapStringPointer(input.PrivacyPolicyURL),
			Summary:          twirputils.WrapStringPointer(input.Summary),
			SupportEmail:     twirputils.WrapStringPointer(input.SupportEmail),
			ViewerSummary:    twirputils.WrapStringPointer(input.ViewerSummary),
		},
	}

	if len(input.Categories) > 0 {
		req.UpdateData.Categories = &discovery.OptionalStringList{Values: input.Categories}
	}
	if len(input.Games) > 0 {
		req.UpdateData.Games = &discovery.OptionalIntList{Values: input.Games}
	}
	if len(input.IconPaths) > 0 {
		req.UpdateData.IconPaths = &discovery.OptionalStringStringMap{Values: input.IconPaths}
	}
	if len(input.IconURLs) > 0 {
		req.UpdateData.IconURLs = &discovery.OptionalStringStringMap{Values: input.IconURLs}
	}
	if len(input.ScreenshotPaths) > 0 {
		req.UpdateData.ScreenshotPaths = &discovery.OptionalStringList{Values: input.ScreenshotPaths}
	}
	if len(input.ScreenshotURLs) > 0 {
		req.UpdateData.ScreenshotURLs = &discovery.OptionalStringList{Values: input.ScreenshotURLs}
	}

	return discoman.RetrieveClient(ctx).PutExtensionVersionDiscoveryData(ctx, req)
}
