package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/twirputils"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func UpdateFeaturedCarouselEntry(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	fceid := p.Get("fceid")

	var body documents.AddFeaturedCarouselEntryRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.UpdateFeaturedCarouselEntryRequest{
			ID: fceid,
			FeaturedCarouselEntry: &discovery.FeaturedCarouselEntryUpsert{
				CarouselID: twirputils.WrapStringPointer(body.CarouselID),
				Order:      twirputils.WrapFloatPointer(body.Order),
				Content: &discovery.FeaturedCarouselEntryContent{
					ImageURL:     body.Content.ImageURL,
					ClickThrough: body.Content.ClickThrough,
					Title:        body.Content.Title,
				},
			},
		}

		resp, err := discoveryClient.UpdateFeaturedCarouselEntry(ctx, req)
		if err != nil {
			return nil, err
		}

		doc := protocol.FromDiscoveryFeaturedCarouselEntryDocument(resp.GetFeaturedCarouselEntry())

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.UpdateFeaturedCarouselEntry(ctx, fceid, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
