package discoveryapi

import (
	"context"

	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/twirputils"
	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/config"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

func UpdateFeaturedSchedule(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	fsid := p.Get("fsid")

	var body documents.AddFeaturedScheduleRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	if config.RetrieveConfig(ctx).CallDiscovery {
		discoveryClient := discoman.RetrieveClient(ctx)

		req := &discovery.UpdateFeaturedScheduleRequest{
			ScheduleID: fsid,
			FeaturedSchedule: &discovery.FeaturedScheduleUpsert{
				Slug:        twirputils.WrapStringPointer(body.Slug),
				Description: body.Description,
			},
		}

		resp, err := discoveryClient.UpdateFeaturedSchedule(ctx, req)
		if err != nil {
			return nil, err
		}

		doc, err := protocol.FromDiscoveryFeaturedScheduleDocument(resp.GetFeaturedSchedule())
		if err != nil {
			return nil, err
		}

		return doc, nil
	}

	emsClient := ems.RetrieveClient(ctx)
	resp, err := emsClient.UpdateFeaturedSchedule(ctx, fsid, body, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return resp, nil
}
