package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"

	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"
)

// SetFeatureFlags - set an extension's feature flags on a channel
func SetFeatureFlags(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("eid")
	version := p.Get("version")
	cid := p.Get("cid")

	var body request.SetFeatureFlagsDocument
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	emsClient := ems.RetrieveClient(ctx)

	flags := emsdocs.SetFeatureFlagsDocument{
		CanSendChat: body.CanSendChat,
		CanUseBits:  body.CanUseBits,
	}

	resp, err := emsClient.SetFeatureFlags(ctx, eid, version, cid, flags, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSInstalledExtensionDocument(resp), nil
}
