package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol"
	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// GetExtensionByID - get a single Eztension by ID
func GetExtensionByID(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("id")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	var extension *emsdocs.ExtensionDocument
	var err error
	if version == "" {
		extension, err = emsClient.GetReleasedExtensionByID(ctx, eid, &twitchclient.ReqOpts{
			AuthorizationToken: auth.Load(ctx),
		})
	} else {
		extension, err = emsClient.GetExtensionByID(ctx, eid, version, &twitchclient.ReqOpts{
			AuthorizationToken: auth.Load(ctx),
		})
	}

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionDocument(extension), nil
}
