package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/response"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	emsdocs "code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/golibs/params"
)

// GetExtensions - search extensions
func GetExtensions(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.GetExtensionsParams
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	emsClient := ems.RetrieveClient(ctx)

	params := emsdocs.GetExtensionsParams{
		Offset: body.Offset,
		Limit:  body.Limit,
	}

	for _, search := range body.Searches {
		params.Searches = append(params.Searches, emsdocs.SearchTerm{
			Field: search.Field,
			Term:  search.Term,
			Boost: search.Boost,
		})
	}
	for _, sort := range body.Sorts {
		params.Sorts = append(params.Sorts, emsdocs.SortField{
			Field:     sort.Field,
			Direction: sort.Direction,
		})
	}

	resp, err := emsClient.GetExtensions(ctx, params, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	doc := response.ExtensionsDocument{
		Count:      resp.Count,
		Extensions: []*response.ExtensionDocument{},
	}

	for _, extension := range resp.Extensions {
		extensionDoc := protocol.FromEMSExtensionDocument(extension)
		doc.Extensions = append(doc.Extensions, extensionDoc)
	}

	return doc, nil
}
