package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol"

	"code.justin.tv/extensions/orchestration/service/protocol/response"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// GetMobileExtensionsByChannelID - get the list of extensions installed on a channel that have a mobile view
func GetMobileExtensionsByChannelID(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")

	emsClient := ems.RetrieveClient(ctx)

	installations, err := emsClient.GetMobileExtensionsByChannelID(ctx, cid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	resp := response.InstalledExtensionsDocument{
		InstalledExtensions: []*response.InstalledExtensionDocument{},
	}

	for _, installation := range installations.InstalledExtensions {
		resp.InstalledExtensions = append(resp.InstalledExtensions, protocol.FromEMSInstalledExtensionDocument(installation))
	}

	return resp, nil
}
