package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/protocol"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// InstallExtensionV2 - install an extension
func InstallExtensionV2(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("eid")
	version := p.Get("version")
	cid := p.Get("cid")

	emsClient := ems.RetrieveClient(ctx)

	resp, err := emsClient.InstallExtensionV2(ctx, eid, version, cid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSInstalledExtensionDocument(resp), nil
}
