package api

import (
	"strconv"

	"code.justin.tv/gds/gds/golibs/params"
)

var (
	defaultOffsetStr = "0"
	defaultLimitStr  = "10"
)

const (
	offsetParam = "offset"
	limitParam  = "limit"
)

func GetPagination(p *params.Params) (offset, limit int, err error) {
	offsetStr := p.GetOptional(offsetParam)
	if offsetStr == nil {
		offsetStr = &defaultOffsetStr
	}
	limitStr := p.GetOptional(limitParam)
	if limitStr == nil {
		limitStr = &defaultLimitStr
	}
	offset, err = strconv.Atoi(*offsetStr)
	if err != nil {
		return
	}
	limit, err = strconv.Atoi(*limitStr)
	return
}
