package api

import (
	"fmt"
	"io"
	"net/http"

	oconfig "code.justin.tv/extensions/orchestration/service/config"
)

func copyHeader(dst, src http.Header) {
	for k, vv := range src {
		for _, v := range vv {
			dst.Add(k, v)
		}
	}
}

// Proxy forwards the incoming request to EMS
func Proxy(w http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	cfg := oconfig.RetrieveConfig(ctx)

	outgoingRequest, err := http.NewRequest(req.Method, fmt.Sprintf("%s%s", cfg.EMSURL, req.URL), req.Body)
	copyHeader(outgoingRequest.Header, req.Header)

	resp, err := http.DefaultClient.Do(outgoingRequest)
	if err != nil {
		w.WriteHeader(http.StatusInternalServerError)
		return
	}

	defer resp.Body.Close()
	copyHeader(w.Header(), resp.Header)
	w.WriteHeader(resp.StatusCode)
	io.Copy(w, resp.Body)
}
