package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// RequiredInstallationConfiguration - set an extension's required configuration string on a channel
func RequiredInstallationConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("eid")
	version := p.Get("version")
	cid := p.Get("cid")

	var body request.RequiredInstallationConfiguration
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	emsClient := ems.RetrieveClient(ctx)

	return nil, emsClient.SetInstallationConfiguration(ctx, eid, version, cid, body.RequiredConfigurationString, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

}
