package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol/request"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// TransitionExtensionState - move extensions through their lifecycle
func TransitionExtensionState(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body request.StateTransition
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	eid := p.Get("id")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	return nil, emsClient.TransitionExtensionState(ctx, eid, version, body.State, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

}
