package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/golibs/params"
)

// UninstallExtension - uninstall an extension
func UninstallExtension(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	eid := p.Get("eid")
	version := p.Get("version")
	cid := p.Get("cid")

	emsClient := ems.RetrieveClient(ctx)

	return nil, emsClient.UninstallExtension(ctx, eid, version, cid, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

}
