package api

import (
	"context"

	"code.justin.tv/extensions/orchestration/service/auth"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	"code.justin.tv/extensions/orchestration/service/protocol"
	"code.justin.tv/extensions/orchestration/service/protocol/shared"
	"code.justin.tv/foundation/twitchclient"
	emsprotocol "code.justin.tv/gds/gds/extensions/ems/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

// UpdateVersionImagePath - update assets for an extension version
func UpdateVersionImagePath(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var body shared.UpdateImagePathRequest
	if err := p.ParseJSONBody(&body); err != nil {
		return nil, err
	}

	eid := p.Get("eid")
	version := p.Get("version")

	emsClient := ems.RetrieveClient(ctx)

	tokenBytes := append(body.Token[:0:0], body.Token...)

	params := emsprotocol.UpdateImagePathRequest{
		Path:  body.Path,
		Type:  body.Type,
		Token: tokenBytes,
	}

	manifest, err := emsClient.UpdateVersionImagePath(ctx, eid, version, params, &twitchclient.ReqOpts{
		AuthorizationToken: auth.Load(ctx),
	})

	if err != nil {
		return nil, err
	}

	return protocol.FromEMSExtensionManifest(manifest), nil
}
