package clients

import (
	"net/http"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/orchestration/service/clients/discoman"
	"code.justin.tv/extensions/orchestration/service/clients/ems"
	gdsems "code.justin.tv/gds/gds/extensions/ems/client"
)

// StoreClients builds a goji middleware that automatically places all of
// the clients for downstream services into the context for use by
// API handlers
func WithClients(emsClient gdsems.Client, discoveryClient discovery.Discovery) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := ems.WithClient(r.Context(), emsClient)
			ctx = discoman.WithClient(ctx, discoveryClient)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}
