package discoman

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
)

var discoveryKey = new(int)

// WithClient builds a goji middleware that stores the discovery client
// on the request so API handlers can access it
func WithClient(ctx context.Context, client discovery.Discovery) context.Context {
	return context.WithValue(ctx, discoveryKey, client)
}

// RetrieveClient retrieves the discovery client from a request context.
func RetrieveClient(ctx context.Context) discovery.Discovery {
	if value, ok := ctx.Value(discoveryKey).(discovery.Discovery); ok {
		return value
	}
	return nil
}
