package ems

import (
	"context"

	gdsems "code.justin.tv/gds/gds/extensions/ems/client"
)

var emsKey = new(int)

// WithClient builds a goji middleware that stores the EMS client
// on the request so API handlers can access it
func WithClient(ctx context.Context, client gdsems.Client) context.Context {
	return context.WithValue(ctx, emsKey, client)
}

// RetrieveClient retrieves credentials from a request context.
func RetrieveClient(ctx context.Context) gdsems.Client {
	if value, ok := ctx.Value(emsKey).(gdsems.Client); ok {
		return value
	}
	return nil
}
