package config

const (
	ConfigStatsFrequent = "stats.frequency.frequent"
	ConfigStatsCommon   = "stats.frequency.common"
	ConfigStatsRare     = "stats.frequency.rare"
	ConfigEMSURL        = "ems-url"
)

// Config has all configuration options for the orchestrator
type Config struct {
	EMSURL               string `c7:"emsUrl" validate:"nonzero"`
	Port                 int64  `c7:"port" validate:"nonzero"`
	HTTPPort             int64  `c7:"httpPort" validate:"nonzero"`
	HTTPDebugPort        int64  `c7:"httpDebugPort" validate:"nonzero"`
	DiscoURL             string `c7:"discoUrl" validate:"nonzero"`
	CallDiscovery        bool   `c7:"callDiscovery"`
	CallDiscoveryEMSAPIs bool   `c7:"callDiscoveryEMSAPIs"`
}
