package config

import (
	"context"
	"net/http"
)

var configKey = new(int)

// Middleware creates a middleware http.Handler that sets the configuration value
// on each request context so API handlers can access it.
func Middleware(cfg *Config) func(http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := Set(r.Context(), cfg)
			h.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

// Set sets the config value on a context.Context.
func Set(ctx context.Context, cfg *Config) context.Context {
	return context.WithValue(ctx, configKey, cfg)
}

// RetrieveConfig retrieves the config value from a context.Context.
func RetrieveConfig(ctx context.Context) *Config {
	if value, ok := ctx.Value(configKey).(*Config); ok {
		return value
	}
	return nil
}
