package request

// Manifest is the JSON structure the client will use to upload a new extension
// into the manager service.
// note fields "IconURL" and "ScreenshotURLs" allow the sender to
// specify a full URL to the icons and screenshots instead of having us upload
// them
type Manifest struct {
	AssetHash                    string            `json:"asset_hash"`
	AssetPaths                   []string          `json:"asset_paths,omitempty"`
	AuthorEmail                  string            `json:"author_email"`
	AuthorName                   string            `json:"author_name"`
	BitsEnabled                  bool              `json:"bits_enabled"`
	BitsSupportLevel             string            `json:"bits_support_level"`
	BroadcasterWhitelist         []string          `json:"broadcaster_whitelist"`
	Categories                   []string          `json:"categories"`
	ConfigurationLocation        string            `json:"configuration_location"`
	Description                  string            `json:"description"`
	EULATOSURL                   string            `json:"eula_tos_url"`
	ExtensionID                  string            `json:"extension_id"`
	HasChatSupport               bool              `json:"has_chat_support"`
	Games                        []int             `json:"games"`
	IconPath                     string            `json:"icon_path"`
	IconPaths                    map[string]string `json:"icon_paths"`
	IconURL                      string            `json:"icon_URL"`
	IconURLs                     map[string]string `json:"icon_urls"`
	Name                         string            `json:"name"`
	PrivacyPolicyURL             string            `json:"privacy_policy_url"`
	RequestIdentityLink          bool              `json:"request_identity_link"`
	RequiredBroadcasterAbilities []string          `json:"required_broadcaster_abilities"`
	RequiredConfigurationString  string            `json:"required_configuration_string"`
	ScreenshotPaths              []string          `json:"screenshot_paths"`
	ScreenshotURLs               []string          `json:"screenshot_urls"`
	SKU                          string            `json:"sku"`
	SubscriptionsSupportLevel    string            `json:"subscriptions_support_level"`
	Summary                      string            `json:"summary"`
	SupportEmail                 string            `json:"support_email"`
	TestingAccounts              []string          `json:"testing_accounts"`
	TestingBaseURI               string            `json:"testing_base_uri"`
	VendorCode                   string            `json:"vendor_code"`
	Version                      string            `json:"extension_version"`
	Views                        ManifestViews     `json:"views"`
	WhitelistedConfigURLs        []string          `json:"whitelisted_config_urls"`
	WhitelistedPanelURLs         []string          `json:"whitelisted_panel_urls"`
}

type ManifestViews struct {
	Panel        PanelManifest        `json:"panel"`
	VideoOverlay VideoOverlayManifest `json:"video_overlay"`
	Component    ComponentManifest    `json:"component"`
	Mobile       MobileManifest       `json:"mobile"`
	Config       ConfigManifest       `json:"config"`
	LiveConfig   LiveConfigManifest   `json:"live_config"`
}

type PanelManifest struct {
	ViewerPath string `json:"viewer_path"`
	Height     int    `json:"height"`
}

type VideoOverlayManifest struct {
	ViewerPath string `json:"viewer_path"`
}

type ComponentManifest struct {
	ViewerPath   string  `json:"viewer_path"`
	AspectWidth  int     `json:"aspect_width"`
	AspectHeight int     `json:"aspect_height"`
	Size         float64 `json:"size"`
	Zoom         bool    `json:"zoom"`
	ZoomPixels   int     `json:"zoom_pixels"`
}

type MobileManifest struct {
	ViewerPath string `json:"viewer_path"`
}

type ConfigManifest struct {
	ViewerPath string `json:"viewer_path"`
}

type LiveConfigManifest struct {
	ViewerPath string `json:"viewer_path"`
}
