package request

// SearchTerm is the JSON structure that describes a field to search on, and a term to search for.
type SearchTerm struct {
	Field string  `json:"field"`
	Term  string  `json:"term"`
	Boost float64 `json:"boost"`
}

// SortField is the JSON structure that describes a field to sort on, and the sort direction.
type SortField struct {
	Field     string `json:"field"`
	Direction string `json:"direction"`
}

// GetExtensionsParams captures everything that GetExtensions needs to know to search for
// the desired extensions -- search terms, sorts, and pagination information
type GetExtensionsParams struct {
	Searches []SearchTerm `json:"searches"`
	Sorts    []SortField  `json:"sorts"`
	Offset   int          `json:"offset"`
	Limit    int          `json:"limit"`
}
