package response

// Deprecated but still used by older mobile clients
type ViewerURLs struct {
	Mobile       string `json:"mobile,omitempty"`
	Panel        string `json:"panel,omitempty"`
	VideoOverlay string `json:"video_overlay,omitempty"`
	Component    string `json:"component,omitempty"`
	Hidden       string `json:"hidden,omitempty"`
}

// ExtensionViews contains all of the view-specific information
type ExtensionViews struct {
	Mobile       *MobileExtensionView       `json:"mobile,omitempty"`
	Panel        *PanelExtensionView        `json:"panel,omitempty"`
	VideoOverlay *VideoOverlayExtensionView `json:"video_overlay,omitempty"`
	Component    *ComponentExtensionView    `json:"component,omitempty"`
	Hidden       *HiddenExtensionView       `json:"hidden,omitempty"`
	Config       *ConfigExtensionView       `json:"config,omitempty"`
	LiveConfig   *LiveConfigExtensionView   `json:"live_config,omitempty"`
}

type MobileExtensionView struct {
	CanLinkExternalContent bool   `json:"can_link_external_content"`
	ViewerURL              string `json:"viewer_url"`
}

type PanelExtensionView struct {
	CanLinkExternalContent bool   `json:"can_link_external_content"`
	Height                 int    `json:"height"`
	ViewerURL              string `json:"viewer_url"`
}

type VideoOverlayExtensionView struct {
	CanLinkExternalContent bool   `json:"can_link_external_content"`
	ViewerURL              string `json:"viewer_url"`
}

type ComponentExtensionView struct {
	AspectWidth            int     `json:"aspect_width"`
	AspectHeight           int     `json:"aspect_height"`
	CanLinkExternalContent bool    `json:"can_link_external_content"`
	Size                   float64 `json:"size"`
	ViewerURL              string  `json:"viewer_url"`
	Zoom                   bool    `json:"zoom"`
	ZoomPixels             int     `json:"zoom_pixels"`
}

type HiddenExtensionView struct {
	CanLinkExternalContent bool   `json:"can_link_external_content"`
	ViewerURL              string `json:"viewer_url"`
}

type ConfigExtensionView struct {
	CanLinkExternalContent bool   `json:"can_link_external_content"`
	ViewerURL              string `json:"viewer_url"`
}

type LiveConfigExtensionView struct {
	CanLinkExternalContent bool   `json:"can_link_external_content"`
	ViewerURL              string `json:"viewer_url"`
}

// ExtensionDocument is the data we send back on the wire about an Extension.
type ExtensionDocument struct {
	Anchor                       string            `json:"anchor"`
	AssetURLs                    []string          `json:"asset_urls"`
	AuthorName                   string            `json:"author_name"`
	BaseURI                      string            `json:"base_uri"`
	BitsEnabled                  bool              `json:"bits_enabled"`
	Categories                   []string          `json:"categories"`
	CanInstall                   bool              `json:"can_install"`
	ConfigURL                    string            `json:"config_url"` // deprecated, need to remove usage from GQL
	ConfigurationLocation        string            `json:"configuration_location"`
	Description                  string            `json:"description"`
	EULATOSURL                   string            `json:"eula_tos_url"`
	Games                        []int             `json:"games"`
	HasChatSupport               bool              `json:"has_chat_support"`
	IconURL                      string            `json:"icon_url"`
	IconURLs                     map[string]string `json:"icon_urls"`
	ID                           string            `json:"id"`
	InstallationCount            int               `json:"installation_count"` // deprecated, but removing it is a PITA
	LiveConfigURL                string            `json:"live_config_url"`    // deprecated, need to remove usage from GQL
	Name                         string            `json:"name"`
	PanelHeight                  int               `json:"panel_height"` // deprecated, need to remove usage from GQL
	PrivacyPolicyURL             string            `json:"privacy_policy_url"`
	RequestIdentityLink          bool              `json:"request_identity_link"`
	RequiredBroadcasterAbilities []string          `json:"required_broadcaster_abilities"`
	RequiredConfiguration        string            `json:"required_configuration"`
	ScreenshotURLs               []string          `json:"screenshot_urls"`
	SKU                          string            `json:"sku"`
	State                        string            `json:"state"`
	Summary                      string            `json:"summary"`
	SupportEmail                 string            `json:"support_email"`
	VendorCode                   string            `json:"vendor_code"`
	Version                      string            `json:"version"`
	ViewerURL                    string            `json:"viewer_url"` // deprecated, need to remove usage from GQL
	ViewerURLs                   ViewerURLs        `json:"viewer_urls"`
	Views                        ExtensionViews    `json:"views"`
	WhitelistedConfigURLs        []string          `json:"whitelisted_config_urls"`
	WhitelistedPanelURLs         []string          `json:"whitelisted_panel_urls"`
}

// ExtensionsDocument is the data we send back on the wire about multiple extensions,
// along with the TOTAL number of extensions in the full query, for pagination purposes
type ExtensionsDocument struct {
	Count      int64                `json:"count"`
	Extensions []*ExtensionDocument `json:"extensions"`
}
