package response

import "code.justin.tv/extensions/orchestration/service/protocol/shared"

// ActivationRequirement is an enum that represents tasks that must be
// completed before an install can be activated
type ActivationRequirement string

const (
	// Anchor : every install must declare its attachment point
	Anchor ActivationRequirement = "anchor"
	// Configure : every install must be properly configured
	Configure ActivationRequirement = "configure"
	// Configure : every install must be properly configured
	HostedConfig ActivationRequirement = "hostedConfig"
	// Release : this was a public install but the extension was unpublished
	Release ActivationRequirement = "release"
	// Unknown : unable to interpret this value, code is likely out of date
	Unknown ActivationRequirement = "unknown"

	hostedConfigPrefix    = "hosted"
	hostedConfigSeparator = ":"
)

// InstallationAbilitiesDocument represents the abilities an installation has on a specific
// channel for the requesting credentials
type InstallationAbilitiesDocument struct {
	IsChatEnabled bool `json:"is_chat_enabled"`
	IsBitsEnabled bool `json:"is_bits_enabled"`
}

// FeatureFlagsDocument represents the features a broadcaster can choose to enable/disable
// on a per-installation basis
type FeatureFlagsDocument struct {
	CanSendChat bool `json:"can_send_chat"`
	CanUseBits  bool `json:"can_use_bits"`
}

// InstallationStatusDocument is the data we send back on the wire about the nature
// of the installation of a given extension on a channel.
type InstallationStatusDocument struct {
	Abilities         *InstallationAbilitiesDocument `json:"abilities"`
	ActivationState   string                         `json:"activation_state"`
	Anchor            *shared.AnyAnchorParam         `json:"activation_configuration"`
	CanActivate       bool                           `json:"can_activate"`
	ID                string                         `json:"id"`
	PermittedFeatures *FeatureFlagsDocument          `json:"permitted_abilities"`
}

// InstalledExtensionDocument is a pair of extension, installation status structures
// that combines global information about an extension with channel-specific
// information about the nature of its installation.
type InstalledExtensionDocument struct {
	Extension          *ExtensionDocument          `json:"extension"`
	InstallationStatus *InstallationStatusDocument `json:"installation_status_document"`
	RequiredActions    []ActivationRequirement     `json:"required_action"`
}

// InstalledExtensionsDocument is a list of installed extensions documents.
type InstalledExtensionsDocument struct {
	InstalledExtensions []*InstalledExtensionDocument `json:"installed_extensions"`
}
