package response

// UploaderResponse is the data we send back for uploading asset requests
type UploaderResponse struct {
	// Url is a pre-signed upload URL, which comes from AWS's API
	Url string `json:"url,omitempty"`
	// UploadID is a uuid
	UploadId string `json:"upload_id,omitempty"`
}

// UploaderResponses is the map of UploaderResponses we send back for uploader
// Key of map represents uploading asset's type
type UploaderResponses struct {
	UploaderResponses map[string][]*UploaderResponse `json:"uploader_responses"`
}
