package shared

import (
	"time"
)

// Extension manifests post-devsite migration

type ExtensionManifestResponse struct {
	Manifests   map[string]*ExtensionManifest
	Deleted     bool
	PagingToken *string
}

type ExtensionManifest struct {
	ID      string
	Version string
	Format  int // 1 for this version

	AssetData            AssetInfo
	ExtensionRuntimeData ExtensionRuntime
	DiscoveryData        DiscoveryMetadata
	AccessControlData    AccessControl
	DeveloperData        DeveloperInfo
}

type DiscoveryMetadata struct {
	Summary          string
	Description      string
	ScreenshotPaths  []string
	ScreenshotURLs   []string
	Categories       []string
	EULATOSURL       string
	Games            []int
	IconPaths        map[string]string
	IconURLs         map[string]string
	PrivacyPolicyURL string
	SupportEmail     string
	Name             string
	AuthorName       string
}

type ExtensionRuntime struct {
	BitsEnabled                  bool
	BitsSupportLevel             string
	ConfigurationLocation        string
	HasChatSupport               bool
	RequestIdentityLink          bool
	RequiredBroadcasterAbilities []string
	RequiredConfigurationString  string
	SKU                          string
	SubscriptionsSupportLevel    string
	VendorCode                   string
	Views                        *ManifestViews
	WhitelistedConfigURLs        []string
	WhitelistedPanelURLs         []string
}

type AccessControl struct {
	BroadcasterWhitelist []string
	TestingAccounts      []string
}

type UpdateAssetInfoRequest struct {
	Info  AssetInfo
	Token []byte
}

type UpdateImagePathRequest struct {
	Path  string
	Type  string
	Token []byte
}

type AssetInfo struct {
	ExtensionID string
	AssetHash   string
	UploadedBy  string
	UploadedAt  *time.Time
	FileSize    string
	FileName    string
	UploadID    string
	BaseURI     *string
}

type DeveloperInfo struct {
	AuthorEmail        string
	LastTransitionedAt *time.Time
	CreatedAt          *time.Time
	TestingBaseURI     string
	VersionState       string
}

type ManifestViews struct {
	Component    *ComponentManifest
	Config       *ConfigManifest
	Hidden       *HiddenManifest
	LiveConfig   *LiveConfigManifest
	Mobile       *MobileManifest
	Panel        *PanelManifest
	VideoOverlay *VideoOverlayManifest
}

type ComponentManifest struct {
	AspectHeight int
	AspectWidth  int
	Size         int // fixed point * 10000 for consistent marshalling
	ViewerPath   string
	Zoom         bool
	ZoomPixels   int
}

type ConfigManifest struct {
	ViewerPath string
}

type HiddenManifest struct {
	ViewerPath string
}

type LiveConfigManifest struct {
	ViewerPath string
}

type MobileManifest struct {
	ViewerPath string
}

type PanelManifest struct {
	Height     int
	ViewerPath string
}

type VideoOverlayManifest struct {
	ViewerPath string
}
