package routes

import (
	"code.justin.tv/extensions/orchestration/service/api"
	"code.justin.tv/extensions/orchestration/service/api/discoveryapi"
)

// CreateRoutes appends all the route handlers onto the Server's list of routes.  They will be
// added to the mux later.  This is done so we can attach metadata to the Route objects (e.g.,
// capabilities)
func (s *Server) CreateRoutes() {
	s.Post("/extensions", "add_extensions", api.AddExtension)
	s.Post("/extensions/search", "get_extensions", api.GetExtensions)

	// XXX I don't think *anyone* uses this, can probably not include here and delete from EMS
	// s.Get("/extensions/search_sort_fields", "get_search_sort_fields", api.GetSearchSortFields)

	s.Get("/extensions", "get_extensions_by_keys", api.GetExtensionsByKeys)
	s.Get("/extensions/:id", "get_extensions_by_id", api.GetExtensionByID)
	s.Get("/extensions/:id/:version", "get_extensions_by_id", api.GetExtensionByID)
	s.Put("/extensions/:id/:version", "transtion_extension_state", api.TransitionExtensionState)
	s.Delete("/extensions/:id", "delete_extension", api.DeleteExtension)
	s.Delete("/extensions/:id/:version", "delete_extension_version", api.DeleteExtensionVersion)

	s.Get("/mobile/channels/:cid/extensions", "get_mobile_extensions_by_channel_id", api.GetMobileExtensionsByChannelID)
	s.Get("/channels/:cid/extensions/v2", "get_extensions_by_channel_id", api.GetExtensionsByChannelID)
	s.Put("/channels/:cid/extensions/activations", "activate_extensions", api.ActivateExtensions)
	s.Post("/channels/:cid/extensions/:eid/:version", "install_extension", api.InstallExtension)
	s.Post("/channels/:cid/extensions/:eid/:version/v2", "install_extension", api.InstallExtensionV2)
	s.Delete("/channels/:cid/extensions/:eid/:version", "uninstall_extension", api.UninstallExtension)
	s.Put("/channels/:cid/extensions/:eid/:version/required_configuration", "required_installation_configuration", api.RequiredInstallationConfiguration)
	s.Put("/channels/:cid/extensions/:eid/:version/features", "set_feature_flags", api.SetFeatureFlags)

	// DEVSITE

	s.Post("/developer/extensions", "developer_add_extension", api.DeveloperAddExtension)
	s.Put("/developer/extensions/transitiion/:id/:version", "developer_transition_extension_state", api.DeveloperTransitionExtensionState)
	s.Post("/developer/extensions/transitiion/:id/:version/clone", "developer_clone_extension", api.DeveloperCloneExtension)
	s.Get("/developer/extensions/:id", "developer_get_extension_manifests", api.DeveloperGetExtensionManifests)
	s.Get("/developer/extensions/:id/:version", "developer_get_extension_manifest", api.DeveloperGetExtensionManifest)

	// DEVSITE ASSET UPLOADS
	s.Put("/developer/extensions/assets/:id/:version", "update_assets", api.DeveloperUpdateVersionAssetInfo)
	s.Delete("/extensions/:id/:version/image_assets", "delete_extension_image_assets", api.DeveloperDeleteExtensionImageAssets)

	// Discovery
	// CATEGORIES
	s.Post("/categories", "add_category", discoveryapi.AddCategory)
	s.Get("/categories", "get_categories", discoveryapi.GetCategories)
	s.Put("/categories/:cid", "update_category", discoveryapi.UpdateCategory)
	s.Get("/categories/:cid", "get_category", discoveryapi.GetCategory)
	s.Get("/categories/:cid/extensions", "get_category_extensions", discoveryapi.GetCategoryExtensions)
	s.Delete("/categories/:cid", "delete_category", discoveryapi.DeleteCategory)
	s.Put("/categories/:cid/translations/:lang", "edit_category_translation", discoveryapi.EditCategoryTranslation)
	s.Post("/categories/order", "order_categories", discoveryapi.OrderCategories)
	s.Post("/categories/:cid/extensions/:eid", "add_extension_to_category", discoveryapi.AddExtensionToCategory)
	s.Delete("/categories/:cid/extensions/:eid", "remove_extension_from_category", discoveryapi.RemoveExtensionFromCategory)
	s.Post("/extensions/:eid/:version/categories/:cid", "add_dev_category_to_extension", discoveryapi.AddCategoryToExtension)
	s.Post("/categories/:cid/order", "order_category", discoveryapi.OrderCategory)

	// GAMES
	s.Post("/extensions/:eid/:version/games/:gid", "add_game_to_extension", discoveryapi.AddGameToExtension)
	s.Delete("/extensions/:eid/:version/games/:gid", "delete_game_from_extension", discoveryapi.DeleteGameFromExtension)

	// FEATURED CAROUSELS
	s.Post("/featured_schedules", "add_featured_schedule", discoveryapi.AddFeaturedSchedule)
	s.Get("/featured_schedules", "get_featured_schedules", discoveryapi.GetFeaturedSchedules)
	s.Put("/featured_schedules/:fsid", "update_featured_schedule", discoveryapi.UpdateFeaturedSchedule)
	s.Delete("/featured_schedules/:fsid", "delete_featured_schedule", discoveryapi.DeleteFeaturedSchedule)
	s.Get("/featured_schedules/:fsid", "get_featured_schedule", discoveryapi.GetFeaturedSchedule)

	s.Post("/featured_carousels", "add_featured_carousel", discoveryapi.AddFeaturedCarousel)
	s.Get("/featured_carousels", "get_featured_carousel", discoveryapi.GetFeaturedCarousels)
	s.Put("/featured_carousels/:fcid", "update_featured_carousel", discoveryapi.UpdateFeaturedCarousel)
	s.Delete("/featured_carousels/:fcid", "delete_featured_carousel", discoveryapi.DeleteFeaturedCarousel)
	s.Get("/featured_carousels/:fcid", "get_featured_carousel", discoveryapi.GetFeaturedCarousel)

	s.Post("/featured_carousels/:fcid/order", "order_featured_carousel", discoveryapi.OrderFeaturedCarousel)

	s.Post("/featured_carousel_entries", "add_featured_carousel_entry", discoveryapi.AddFeaturedCarouselEntry)
	s.Get("/featured_carousel_entries", "get_featured_carousel_entries", discoveryapi.GetFeaturedCarouselEntries)
	s.Put("/featured_carousel_entries/:fceid", "update_featured_carousel_entry", discoveryapi.UpdateFeaturedCarouselEntry)
	s.Delete("/featured_carousel_entries/:fceid", "delete_featured_carousel_entry", discoveryapi.DeleteFeaturedCarouselEntry)
	s.Get("/featured_carousel_entries/:fceid", "get_featured_carousel_entry", discoveryapi.GetFeaturedCarouselEntry)
}
