# fetch the routing tables associated with each private subnet, as well as the one routing table associated
# with the public subnets (the external routing table)
data "aws_route_table" "public_0" {
  subnet_id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_public_subnets[0]
}

data "aws_route_table" "private_0" {
  subnet_id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_private_subnets[0]
}

data "aws_route_table" "private_1" {
  subnet_id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_private_subnets[1]
}

data "aws_route_table" "private_2" {
  subnet_id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_private_subnets[2]
}

variable "twitch_gds_prod_subnet" {
  default = "10.196.0.0/18"
}

variable "twitch_gds_prod_vpc_id" {
  default = "vpc-55857831"
}

variable "twitch_gds_prod_account_id" {
  default = "523543649671"
}

data "aws_vpc_peering_connection" "twitch_gds_prod" {
  owner_id   = var.twitch_gds_prod_account_id
  vpc_id     = var.twitch_gds_prod_vpc_id
  cidr_block = var.twitch_gds_prod_subnet
}

resource "aws_route" "route_gds_space_to_gds_peer_0" {
  route_table_id            = data.aws_route_table.public_0.id
  destination_cidr_block    = var.twitch_gds_prod_subnet
  vpc_peering_connection_id = data.aws_vpc_peering_connection.twitch_gds_prod.id
}

resource "aws_route" "route_gds_space_to_gds_peer_private_0" {
  route_table_id            = data.aws_route_table.private_0.id
  destination_cidr_block    = var.twitch_gds_prod_subnet
  vpc_peering_connection_id = data.aws_vpc_peering_connection.twitch_gds_prod.id
}

resource "aws_route" "route_gds_space_to_gds_peer_private_1" {
  route_table_id            = data.aws_route_table.private_1.id
  destination_cidr_block    = var.twitch_gds_prod_subnet
  vpc_peering_connection_id = data.aws_vpc_peering_connection.twitch_gds_prod.id
}

resource "aws_route" "route_gds_space_to_gds_peer_private_2" {
  route_table_id            = data.aws_route_table.private_2.id
  destination_cidr_block    = var.twitch_gds_prod_subnet
  vpc_peering_connection_id = data.aws_vpc_peering_connection.twitch_gds_prod.id
}

