// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: cmd/discovery/rpc/discovery.proto

/*
Package discovery is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	cmd/discovery/rpc/discovery.proto
*/
package discovery

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ===================
// Discovery Interface
// ===================

// Discovery is the service in charge of extension discovery and management
type Discovery interface {
	// AddCategory creates a new category in the discovery data store.
	// Callers must provide credentials allowing them to curate categories
	AddCategory(context.Context, *AddCategoryRequest) (*AddCategoryResponse, error)

	// GetCategories is a paginated API which retrieves categories from the
	// discovery data store
	GetCategories(context.Context, *GetCategoriesRequest) (*GetCategoriesResponse, error)

	// UpdateCategory updates a given category.
	// Callers must provide credentials allowing them to curate categories
	UpdateCategory(context.Context, *UpdateCategoryRequest) (*UpdateCategoryResponse, error)

	// GetCategory retrieves a particular category
	GetCategory(context.Context, *GetCategoryRequest) (*GetCategoryResponse, error)

	// GetCategoryExtensions is a paginated API which retrieves the extensions
	// associated with a given category
	GetCategoryExtensions(context.Context, *GetCategoryExtensionsRequest) (*GetCategoryExtensionsResponse, error)

	// DeleteCategory deletes a given category.
	// Callers must provide credentials allowing them to curate categories
	// Deleting a category requires the category to not be visible and to have no
	// extensions
	DeleteCategory(context.Context, *DeleteCategoryRequest) (*DeleteCategoryResponse, error)

	// EditCategoryTranslation updates the translations for a category.
	// Callers must provide credentials allowing them to curate categories
	EditCategoryTranslation(context.Context, *EditCategoryTranslationRequest) (*EditCategoryTranslationResponse, error)

	// OrderCategories changes the display order of categories.
	// Callers must provide credentials allowing them to curate categories
	OrderCategories(context.Context, *OrderCategoriesRequest) (*OrderCategoriesResponse, error)

	// AddExtensionToCategory adds the given extension to the given category.
	// Category in question must not be a developer category - those need to
	// be managed using AddCategoryToExtension.
	// Callers must provide credentials allowing them to curate categories
	AddExtensionToCategory(context.Context, *AddExtensionToCategoryRequest) (*AddExtensionToCategoryResponse, error)

	// RemoveExtensionFromCategory removes the given extension from the given
	// category. Callers must provide credentials allowing them to curate
	// categories
	RemoveExtensionFromCategory(context.Context, *RemoveExtensionFromCategoryRequest) (*RemoveExtensionFromCategoryResponse, error)

	// AddCategoryToExtension sets the category on a given extension.
	// Callers must provide credentials allowing them to curate categories
	AddCategoryToExtension(context.Context, *AddCategoryToExtensionRequest) (*AddCategoryToExtensionResponse, error)

	// OrderCategory updates the order of a given category.
	// Callers must provide credentials allowing them to curate categories
	OrderCategory(context.Context, *OrderCategoryRequest) (*OrderCategoryResponse, error)

	// AddGameToExtension adds a game on a given extension.
	// Callers must provide credentials allowing them to curate categories
	AddGameToExtension(context.Context, *AddGameToExtensionRequest) (*AddGameToExtensionResponse, error)

	// DeleteGameFromExtension removes a game on a given extension/version.
	// Does not remove it from other versions of the extension.
	// Callers must provide credentials allowing them to curate categories
	DeleteGameFromExtension(context.Context, *DeleteGameFromExtensionRequest) (*DeleteGameFromExtensionResponse, error)

	// AddFeaturedSchedule creates a new featured schedule.
	// Callers must provide credentials allowing them to curate categories
	AddFeaturedSchedule(context.Context, *AddFeaturedScheduleRequest) (*AddFeaturedScheduleResponse, error)

	// GetFeaturedSchedules is a paginated API which gets featured schedules
	GetFeaturedSchedules(context.Context, *GetFeaturedSchedulesRequest) (*GetFeaturedSchedulesResponse, error)

	// UpdateFeaturedSchedule updates a given featured schedule.
	// Callers must provide credentials allowing them to curate categories
	UpdateFeaturedSchedule(context.Context, *UpdateFeaturedScheduleRequest) (*UpdateFeaturedScheduleResponse, error)

	// DeleteFeaturedSchedule deletes a given featured schedule.
	// Callers must provide credentials allowing them to curate categories
	DeleteFeaturedSchedule(context.Context, *DeleteFeaturedScheduleRequest) (*DeleteFeaturedScheduleResponse, error)

	// GetFeaturedSchedule gets a given featured schedule
	GetFeaturedSchedule(context.Context, *GetFeaturedScheduleRequest) (*GetFeaturedScheduleResponse, error)

	// AddFeaturedCarousel creates a new featured carousel.
	// Callers must provide credentials allowing them to curate categories
	AddFeaturedCarousel(context.Context, *AddFeaturedCarouselRequest) (*AddFeaturedCarouselResponse, error)

	// GetFeaturedCarousels is a paginated API which gets featured carousels
	GetFeaturedCarousels(context.Context, *GetFeaturedCarouselsRequest) (*GetFeaturedCarouselsResponse, error)

	// UpdateFeaturedCarousel updates a given featured carousel.
	// Callers must provide credentials allowing them to curate categories
	UpdateFeaturedCarousel(context.Context, *UpdateFeaturedCarouselRequest) (*UpdateFeaturedCarouselResponse, error)

	// DeleteFeaturedCarousel deletes a given featured carousel.
	// Callers must provide credentials allowing them to curate categories
	DeleteFeaturedCarousel(context.Context, *DeleteFeaturedCarouselRequest) (*DeleteFeaturedCarouselResponse, error)

	// GetFeaturedCarousel gets a given featured carousel
	GetFeaturedCarousel(context.Context, *GetFeaturedCarouselRequest) (*GetFeaturedCarouselResponse, error)

	// OrderFeaturedCarousel sets the order of a given featured carousel.
	// Callers must provide credentials allowing them to curate categories
	OrderFeaturedCarousel(context.Context, *OrderFeaturedCarouselRequest) (*OrderFeaturedCarouselResponse, error)

	// AddFeaturedCarouselEntry creates a new featured carousel entry.
	// Callers must provide credentials allowing them to curate categories
	AddFeaturedCarouselEntry(context.Context, *AddFeaturedCarouselEntryRequest) (*AddFeaturedCarouselEntryResponse, error)

	// GetFeaturedCarouselEntries is a paginated API which gets featured carousel
	// entries
	GetFeaturedCarouselEntries(context.Context, *GetFeaturedCarouselEntriesRequest) (*GetFeaturedCarouselEntriesResponse, error)

	// UpdateFeaturedCarouselEntry updates a given featured carousel entry.
	// Callers must provide credentials allowing them to curate categories
	UpdateFeaturedCarouselEntry(context.Context, *UpdateFeaturedCarouselEntryRequest) (*UpdateFeaturedCarouselEntryResponse, error)

	// DeleteFeaturedCarouselEntry deletes a given featured carousel entry.
	// Callers must provide credentials allowing them to curate categories
	DeleteFeaturedCarouselEntry(context.Context, *DeleteFeaturedCarouselEntryRequest) (*DeleteFeaturedCarouselEntryResponse, error)

	// GetFeaturedCarouselEntry gets a given featured carousel entry
	GetFeaturedCarouselEntry(context.Context, *GetFeaturedCarouselEntryRequest) (*GetFeaturedCarouselEntryResponse, error)

	// PutExtensionVersionDiscoveryData puts (creates or updates) the discovery
	// data for a given extension/version pair. Callers must provide credentials
	// allowing them to curate categories
	PutExtensionVersionDiscoveryData(context.Context, *PutExtensionVersionDiscoveryDataRequest) (*PutExtensionVersionDiscoveryDataResponse, error)

	// GetExtensionVersionDiscoveryData gets the discovery data for a given
	// extension/version pair
	GetExtensionVersionDiscoveryData(context.Context, *GetExtensionVersionDiscoveryDataRequest) (*GetExtensionVersionDiscoveryDataResponse, error)

	// DeleteExtensionVersionDiscoveryData deletes the discovery data for a
	// given extension/version pair.  This is a soft delete which is to say it
	// sets the deleted flag to true. Callers must provide credentials allowing
	// them to curate categories
	DeleteExtensionVersionDiscoveryData(context.Context, *DeleteExtensionVersionDiscoveryDataRequest) (*DeleteExtensionVersionDiscoveryDataResponse, error)

	// HardDeleteExtension deletes all versions of discovery data for a particular
	// extension.  This is a hard delete which is to say it deletes the rows from
	// the database. Callers must provide admin credentials.
	HardDeleteExtensionDiscoveryData(context.Context, *HardDeleteExtensionDiscoveryDataRequest) (*HardDeleteExtensionDiscoveryDataResponse, error)
}

// =========================
// Discovery Protobuf Client
// =========================

type discoveryProtobufClient struct {
	client HTTPClient
	urls   [34]string
}

// NewDiscoveryProtobufClient creates a Protobuf client that implements the Discovery interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDiscoveryProtobufClient(addr string, client HTTPClient) Discovery {
	prefix := urlBase(addr) + DiscoveryPathPrefix
	urls := [34]string{
		prefix + "AddCategory",
		prefix + "GetCategories",
		prefix + "UpdateCategory",
		prefix + "GetCategory",
		prefix + "GetCategoryExtensions",
		prefix + "DeleteCategory",
		prefix + "EditCategoryTranslation",
		prefix + "OrderCategories",
		prefix + "AddExtensionToCategory",
		prefix + "RemoveExtensionFromCategory",
		prefix + "AddCategoryToExtension",
		prefix + "OrderCategory",
		prefix + "AddGameToExtension",
		prefix + "DeleteGameFromExtension",
		prefix + "AddFeaturedSchedule",
		prefix + "GetFeaturedSchedules",
		prefix + "UpdateFeaturedSchedule",
		prefix + "DeleteFeaturedSchedule",
		prefix + "GetFeaturedSchedule",
		prefix + "AddFeaturedCarousel",
		prefix + "GetFeaturedCarousels",
		prefix + "UpdateFeaturedCarousel",
		prefix + "DeleteFeaturedCarousel",
		prefix + "GetFeaturedCarousel",
		prefix + "OrderFeaturedCarousel",
		prefix + "AddFeaturedCarouselEntry",
		prefix + "GetFeaturedCarouselEntries",
		prefix + "UpdateFeaturedCarouselEntry",
		prefix + "DeleteFeaturedCarouselEntry",
		prefix + "GetFeaturedCarouselEntry",
		prefix + "PutExtensionVersionDiscoveryData",
		prefix + "GetExtensionVersionDiscoveryData",
		prefix + "DeleteExtensionVersionDiscoveryData",
		prefix + "HardDeleteExtensionDiscoveryData",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &discoveryProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &discoveryProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *discoveryProtobufClient) AddCategory(ctx context.Context, in *AddCategoryRequest) (*AddCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddCategory")
	out := new(AddCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetCategories(ctx context.Context, in *GetCategoriesRequest) (*GetCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategories")
	out := new(GetCategoriesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *discoveryProtobufClient) UpdateCategory(ctx context.Context, in *UpdateCategoryRequest) (*UpdateCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	out := new(UpdateCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetCategory(ctx context.Context, in *GetCategoryRequest) (*GetCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	out := new(GetCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetCategoryExtensions(ctx context.Context, in *GetCategoryExtensionsRequest) (*GetCategoryExtensionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryExtensions")
	out := new(GetCategoryExtensionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *discoveryProtobufClient) DeleteCategory(ctx context.Context, in *DeleteCategoryRequest) (*DeleteCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	out := new(DeleteCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *discoveryProtobufClient) EditCategoryTranslation(ctx context.Context, in *EditCategoryTranslationRequest) (*EditCategoryTranslationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "EditCategoryTranslation")
	out := new(EditCategoryTranslationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *discoveryProtobufClient) OrderCategories(ctx context.Context, in *OrderCategoriesRequest) (*OrderCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategories")
	out := new(OrderCategoriesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *discoveryProtobufClient) AddExtensionToCategory(ctx context.Context, in *AddExtensionToCategoryRequest) (*AddExtensionToCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddExtensionToCategory")
	out := new(AddExtensionToCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *discoveryProtobufClient) RemoveExtensionFromCategory(ctx context.Context, in *RemoveExtensionFromCategoryRequest) (*RemoveExtensionFromCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveExtensionFromCategory")
	out := new(RemoveExtensionFromCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *discoveryProtobufClient) AddCategoryToExtension(ctx context.Context, in *AddCategoryToExtensionRequest) (*AddCategoryToExtensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddCategoryToExtension")
	out := new(AddCategoryToExtensionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *discoveryProtobufClient) OrderCategory(ctx context.Context, in *OrderCategoryRequest) (*OrderCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategory")
	out := new(OrderCategoryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *discoveryProtobufClient) AddGameToExtension(ctx context.Context, in *AddGameToExtensionRequest) (*AddGameToExtensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddGameToExtension")
	out := new(AddGameToExtensionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *discoveryProtobufClient) DeleteGameFromExtension(ctx context.Context, in *DeleteGameFromExtensionRequest) (*DeleteGameFromExtensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameFromExtension")
	out := new(DeleteGameFromExtensionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *discoveryProtobufClient) AddFeaturedSchedule(ctx context.Context, in *AddFeaturedScheduleRequest) (*AddFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedSchedule")
	out := new(AddFeaturedScheduleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetFeaturedSchedules(ctx context.Context, in *GetFeaturedSchedulesRequest) (*GetFeaturedSchedulesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedules")
	out := new(GetFeaturedSchedulesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *discoveryProtobufClient) UpdateFeaturedSchedule(ctx context.Context, in *UpdateFeaturedScheduleRequest) (*UpdateFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedSchedule")
	out := new(UpdateFeaturedScheduleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

func (c *discoveryProtobufClient) DeleteFeaturedSchedule(ctx context.Context, in *DeleteFeaturedScheduleRequest) (*DeleteFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedSchedule")
	out := new(DeleteFeaturedScheduleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetFeaturedSchedule(ctx context.Context, in *GetFeaturedScheduleRequest) (*GetFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedule")
	out := new(GetFeaturedScheduleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	return out, err
}

func (c *discoveryProtobufClient) AddFeaturedCarousel(ctx context.Context, in *AddFeaturedCarouselRequest) (*AddFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarousel")
	out := new(AddFeaturedCarouselResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetFeaturedCarousels(ctx context.Context, in *GetFeaturedCarouselsRequest) (*GetFeaturedCarouselsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousels")
	out := new(GetFeaturedCarouselsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	return out, err
}

func (c *discoveryProtobufClient) UpdateFeaturedCarousel(ctx context.Context, in *UpdateFeaturedCarouselRequest) (*UpdateFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarousel")
	out := new(UpdateFeaturedCarouselResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[21], in, out)
	return out, err
}

func (c *discoveryProtobufClient) DeleteFeaturedCarousel(ctx context.Context, in *DeleteFeaturedCarouselRequest) (*DeleteFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarousel")
	out := new(DeleteFeaturedCarouselResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[22], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetFeaturedCarousel(ctx context.Context, in *GetFeaturedCarouselRequest) (*GetFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousel")
	out := new(GetFeaturedCarouselResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[23], in, out)
	return out, err
}

func (c *discoveryProtobufClient) OrderFeaturedCarousel(ctx context.Context, in *OrderFeaturedCarouselRequest) (*OrderFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "OrderFeaturedCarousel")
	out := new(OrderFeaturedCarouselResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[24], in, out)
	return out, err
}

func (c *discoveryProtobufClient) AddFeaturedCarouselEntry(ctx context.Context, in *AddFeaturedCarouselEntryRequest) (*AddFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarouselEntry")
	out := new(AddFeaturedCarouselEntryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[25], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetFeaturedCarouselEntries(ctx context.Context, in *GetFeaturedCarouselEntriesRequest) (*GetFeaturedCarouselEntriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntries")
	out := new(GetFeaturedCarouselEntriesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[26], in, out)
	return out, err
}

func (c *discoveryProtobufClient) UpdateFeaturedCarouselEntry(ctx context.Context, in *UpdateFeaturedCarouselEntryRequest) (*UpdateFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarouselEntry")
	out := new(UpdateFeaturedCarouselEntryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[27], in, out)
	return out, err
}

func (c *discoveryProtobufClient) DeleteFeaturedCarouselEntry(ctx context.Context, in *DeleteFeaturedCarouselEntryRequest) (*DeleteFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarouselEntry")
	out := new(DeleteFeaturedCarouselEntryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[28], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetFeaturedCarouselEntry(ctx context.Context, in *GetFeaturedCarouselEntryRequest) (*GetFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntry")
	out := new(GetFeaturedCarouselEntryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[29], in, out)
	return out, err
}

func (c *discoveryProtobufClient) PutExtensionVersionDiscoveryData(ctx context.Context, in *PutExtensionVersionDiscoveryDataRequest) (*PutExtensionVersionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "PutExtensionVersionDiscoveryData")
	out := new(PutExtensionVersionDiscoveryDataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[30], in, out)
	return out, err
}

func (c *discoveryProtobufClient) GetExtensionVersionDiscoveryData(ctx context.Context, in *GetExtensionVersionDiscoveryDataRequest) (*GetExtensionVersionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionVersionDiscoveryData")
	out := new(GetExtensionVersionDiscoveryDataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[31], in, out)
	return out, err
}

func (c *discoveryProtobufClient) DeleteExtensionVersionDiscoveryData(ctx context.Context, in *DeleteExtensionVersionDiscoveryDataRequest) (*DeleteExtensionVersionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExtensionVersionDiscoveryData")
	out := new(DeleteExtensionVersionDiscoveryDataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[32], in, out)
	return out, err
}

func (c *discoveryProtobufClient) HardDeleteExtensionDiscoveryData(ctx context.Context, in *HardDeleteExtensionDiscoveryDataRequest) (*HardDeleteExtensionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteExtensionDiscoveryData")
	out := new(HardDeleteExtensionDiscoveryDataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[33], in, out)
	return out, err
}

// =====================
// Discovery JSON Client
// =====================

type discoveryJSONClient struct {
	client HTTPClient
	urls   [34]string
}

// NewDiscoveryJSONClient creates a JSON client that implements the Discovery interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDiscoveryJSONClient(addr string, client HTTPClient) Discovery {
	prefix := urlBase(addr) + DiscoveryPathPrefix
	urls := [34]string{
		prefix + "AddCategory",
		prefix + "GetCategories",
		prefix + "UpdateCategory",
		prefix + "GetCategory",
		prefix + "GetCategoryExtensions",
		prefix + "DeleteCategory",
		prefix + "EditCategoryTranslation",
		prefix + "OrderCategories",
		prefix + "AddExtensionToCategory",
		prefix + "RemoveExtensionFromCategory",
		prefix + "AddCategoryToExtension",
		prefix + "OrderCategory",
		prefix + "AddGameToExtension",
		prefix + "DeleteGameFromExtension",
		prefix + "AddFeaturedSchedule",
		prefix + "GetFeaturedSchedules",
		prefix + "UpdateFeaturedSchedule",
		prefix + "DeleteFeaturedSchedule",
		prefix + "GetFeaturedSchedule",
		prefix + "AddFeaturedCarousel",
		prefix + "GetFeaturedCarousels",
		prefix + "UpdateFeaturedCarousel",
		prefix + "DeleteFeaturedCarousel",
		prefix + "GetFeaturedCarousel",
		prefix + "OrderFeaturedCarousel",
		prefix + "AddFeaturedCarouselEntry",
		prefix + "GetFeaturedCarouselEntries",
		prefix + "UpdateFeaturedCarouselEntry",
		prefix + "DeleteFeaturedCarouselEntry",
		prefix + "GetFeaturedCarouselEntry",
		prefix + "PutExtensionVersionDiscoveryData",
		prefix + "GetExtensionVersionDiscoveryData",
		prefix + "DeleteExtensionVersionDiscoveryData",
		prefix + "HardDeleteExtensionDiscoveryData",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &discoveryJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &discoveryJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *discoveryJSONClient) AddCategory(ctx context.Context, in *AddCategoryRequest) (*AddCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddCategory")
	out := new(AddCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetCategories(ctx context.Context, in *GetCategoriesRequest) (*GetCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategories")
	out := new(GetCategoriesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *discoveryJSONClient) UpdateCategory(ctx context.Context, in *UpdateCategoryRequest) (*UpdateCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	out := new(UpdateCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetCategory(ctx context.Context, in *GetCategoryRequest) (*GetCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	out := new(GetCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetCategoryExtensions(ctx context.Context, in *GetCategoryExtensionsRequest) (*GetCategoryExtensionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryExtensions")
	out := new(GetCategoryExtensionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *discoveryJSONClient) DeleteCategory(ctx context.Context, in *DeleteCategoryRequest) (*DeleteCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	out := new(DeleteCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *discoveryJSONClient) EditCategoryTranslation(ctx context.Context, in *EditCategoryTranslationRequest) (*EditCategoryTranslationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "EditCategoryTranslation")
	out := new(EditCategoryTranslationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *discoveryJSONClient) OrderCategories(ctx context.Context, in *OrderCategoriesRequest) (*OrderCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategories")
	out := new(OrderCategoriesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *discoveryJSONClient) AddExtensionToCategory(ctx context.Context, in *AddExtensionToCategoryRequest) (*AddExtensionToCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddExtensionToCategory")
	out := new(AddExtensionToCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *discoveryJSONClient) RemoveExtensionFromCategory(ctx context.Context, in *RemoveExtensionFromCategoryRequest) (*RemoveExtensionFromCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveExtensionFromCategory")
	out := new(RemoveExtensionFromCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *discoveryJSONClient) AddCategoryToExtension(ctx context.Context, in *AddCategoryToExtensionRequest) (*AddCategoryToExtensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddCategoryToExtension")
	out := new(AddCategoryToExtensionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *discoveryJSONClient) OrderCategory(ctx context.Context, in *OrderCategoryRequest) (*OrderCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategory")
	out := new(OrderCategoryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *discoveryJSONClient) AddGameToExtension(ctx context.Context, in *AddGameToExtensionRequest) (*AddGameToExtensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddGameToExtension")
	out := new(AddGameToExtensionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *discoveryJSONClient) DeleteGameFromExtension(ctx context.Context, in *DeleteGameFromExtensionRequest) (*DeleteGameFromExtensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameFromExtension")
	out := new(DeleteGameFromExtensionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *discoveryJSONClient) AddFeaturedSchedule(ctx context.Context, in *AddFeaturedScheduleRequest) (*AddFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedSchedule")
	out := new(AddFeaturedScheduleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetFeaturedSchedules(ctx context.Context, in *GetFeaturedSchedulesRequest) (*GetFeaturedSchedulesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedules")
	out := new(GetFeaturedSchedulesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *discoveryJSONClient) UpdateFeaturedSchedule(ctx context.Context, in *UpdateFeaturedScheduleRequest) (*UpdateFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedSchedule")
	out := new(UpdateFeaturedScheduleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

func (c *discoveryJSONClient) DeleteFeaturedSchedule(ctx context.Context, in *DeleteFeaturedScheduleRequest) (*DeleteFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedSchedule")
	out := new(DeleteFeaturedScheduleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetFeaturedSchedule(ctx context.Context, in *GetFeaturedScheduleRequest) (*GetFeaturedScheduleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedule")
	out := new(GetFeaturedScheduleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	return out, err
}

func (c *discoveryJSONClient) AddFeaturedCarousel(ctx context.Context, in *AddFeaturedCarouselRequest) (*AddFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarousel")
	out := new(AddFeaturedCarouselResponse)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetFeaturedCarousels(ctx context.Context, in *GetFeaturedCarouselsRequest) (*GetFeaturedCarouselsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousels")
	out := new(GetFeaturedCarouselsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	return out, err
}

func (c *discoveryJSONClient) UpdateFeaturedCarousel(ctx context.Context, in *UpdateFeaturedCarouselRequest) (*UpdateFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarousel")
	out := new(UpdateFeaturedCarouselResponse)
	err := doJSONRequest(ctx, c.client, c.urls[21], in, out)
	return out, err
}

func (c *discoveryJSONClient) DeleteFeaturedCarousel(ctx context.Context, in *DeleteFeaturedCarouselRequest) (*DeleteFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarousel")
	out := new(DeleteFeaturedCarouselResponse)
	err := doJSONRequest(ctx, c.client, c.urls[22], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetFeaturedCarousel(ctx context.Context, in *GetFeaturedCarouselRequest) (*GetFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousel")
	out := new(GetFeaturedCarouselResponse)
	err := doJSONRequest(ctx, c.client, c.urls[23], in, out)
	return out, err
}

func (c *discoveryJSONClient) OrderFeaturedCarousel(ctx context.Context, in *OrderFeaturedCarouselRequest) (*OrderFeaturedCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "OrderFeaturedCarousel")
	out := new(OrderFeaturedCarouselResponse)
	err := doJSONRequest(ctx, c.client, c.urls[24], in, out)
	return out, err
}

func (c *discoveryJSONClient) AddFeaturedCarouselEntry(ctx context.Context, in *AddFeaturedCarouselEntryRequest) (*AddFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarouselEntry")
	out := new(AddFeaturedCarouselEntryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[25], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetFeaturedCarouselEntries(ctx context.Context, in *GetFeaturedCarouselEntriesRequest) (*GetFeaturedCarouselEntriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntries")
	out := new(GetFeaturedCarouselEntriesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[26], in, out)
	return out, err
}

func (c *discoveryJSONClient) UpdateFeaturedCarouselEntry(ctx context.Context, in *UpdateFeaturedCarouselEntryRequest) (*UpdateFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarouselEntry")
	out := new(UpdateFeaturedCarouselEntryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[27], in, out)
	return out, err
}

func (c *discoveryJSONClient) DeleteFeaturedCarouselEntry(ctx context.Context, in *DeleteFeaturedCarouselEntryRequest) (*DeleteFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarouselEntry")
	out := new(DeleteFeaturedCarouselEntryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[28], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetFeaturedCarouselEntry(ctx context.Context, in *GetFeaturedCarouselEntryRequest) (*GetFeaturedCarouselEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntry")
	out := new(GetFeaturedCarouselEntryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[29], in, out)
	return out, err
}

func (c *discoveryJSONClient) PutExtensionVersionDiscoveryData(ctx context.Context, in *PutExtensionVersionDiscoveryDataRequest) (*PutExtensionVersionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "PutExtensionVersionDiscoveryData")
	out := new(PutExtensionVersionDiscoveryDataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[30], in, out)
	return out, err
}

func (c *discoveryJSONClient) GetExtensionVersionDiscoveryData(ctx context.Context, in *GetExtensionVersionDiscoveryDataRequest) (*GetExtensionVersionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionVersionDiscoveryData")
	out := new(GetExtensionVersionDiscoveryDataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[31], in, out)
	return out, err
}

func (c *discoveryJSONClient) DeleteExtensionVersionDiscoveryData(ctx context.Context, in *DeleteExtensionVersionDiscoveryDataRequest) (*DeleteExtensionVersionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExtensionVersionDiscoveryData")
	out := new(DeleteExtensionVersionDiscoveryDataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[32], in, out)
	return out, err
}

func (c *discoveryJSONClient) HardDeleteExtensionDiscoveryData(ctx context.Context, in *HardDeleteExtensionDiscoveryDataRequest) (*HardDeleteExtensionDiscoveryDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteExtensionDiscoveryData")
	out := new(HardDeleteExtensionDiscoveryDataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[33], in, out)
	return out, err
}

// ========================
// Discovery Server Handler
// ========================

type discoveryServer struct {
	Discovery
	hooks *twirp.ServerHooks
}

func NewDiscoveryServer(svc Discovery, hooks *twirp.ServerHooks) TwirpServer {
	return &discoveryServer{
		Discovery: svc,
		hooks:     hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *discoveryServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DiscoveryPathPrefix is used for all URL paths on a twirp Discovery server.
// Requests are always: POST DiscoveryPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DiscoveryPathPrefix = "/twirp/code.justin.tv.extensions.discovery.Discovery/"

func (s *discoveryServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.extensions.discovery")
	ctx = ctxsetters.WithServiceName(ctx, "Discovery")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddCategory":
		s.serveAddCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetCategories":
		s.serveGetCategories(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/UpdateCategory":
		s.serveUpdateCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetCategory":
		s.serveGetCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetCategoryExtensions":
		s.serveGetCategoryExtensions(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/DeleteCategory":
		s.serveDeleteCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/EditCategoryTranslation":
		s.serveEditCategoryTranslation(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/OrderCategories":
		s.serveOrderCategories(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddExtensionToCategory":
		s.serveAddExtensionToCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/RemoveExtensionFromCategory":
		s.serveRemoveExtensionFromCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddCategoryToExtension":
		s.serveAddCategoryToExtension(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/OrderCategory":
		s.serveOrderCategory(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddGameToExtension":
		s.serveAddGameToExtension(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/DeleteGameFromExtension":
		s.serveDeleteGameFromExtension(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddFeaturedSchedule":
		s.serveAddFeaturedSchedule(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetFeaturedSchedules":
		s.serveGetFeaturedSchedules(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/UpdateFeaturedSchedule":
		s.serveUpdateFeaturedSchedule(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/DeleteFeaturedSchedule":
		s.serveDeleteFeaturedSchedule(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetFeaturedSchedule":
		s.serveGetFeaturedSchedule(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddFeaturedCarousel":
		s.serveAddFeaturedCarousel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetFeaturedCarousels":
		s.serveGetFeaturedCarousels(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/UpdateFeaturedCarousel":
		s.serveUpdateFeaturedCarousel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/DeleteFeaturedCarousel":
		s.serveDeleteFeaturedCarousel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetFeaturedCarousel":
		s.serveGetFeaturedCarousel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/OrderFeaturedCarousel":
		s.serveOrderFeaturedCarousel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/AddFeaturedCarouselEntry":
		s.serveAddFeaturedCarouselEntry(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetFeaturedCarouselEntries":
		s.serveGetFeaturedCarouselEntries(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/UpdateFeaturedCarouselEntry":
		s.serveUpdateFeaturedCarouselEntry(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/DeleteFeaturedCarouselEntry":
		s.serveDeleteFeaturedCarouselEntry(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetFeaturedCarouselEntry":
		s.serveGetFeaturedCarouselEntry(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/PutExtensionVersionDiscoveryData":
		s.servePutExtensionVersionDiscoveryData(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/GetExtensionVersionDiscoveryData":
		s.serveGetExtensionVersionDiscoveryData(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/DeleteExtensionVersionDiscoveryData":
		s.serveDeleteExtensionVersionDiscoveryData(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.extensions.discovery.Discovery/HardDeleteExtensionDiscoveryData":
		s.serveHardDeleteExtensionDiscoveryData(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *discoveryServer) serveAddCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddCategoryResponse and nil error while calling AddCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddCategoryResponse and nil error while calling AddCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetCategories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetCategoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCategoriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoriesResponse and nil error while calling GetCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetCategoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCategoriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCategoriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoriesResponse and nil error while calling GetCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveUpdateCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCategoryResponse and nil error while calling UpdateCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCategoryResponse and nil error while calling UpdateCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryResponse and nil error while calling GetCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryResponse and nil error while calling GetCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetCategoryExtensions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryExtensionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryExtensionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetCategoryExtensionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryExtensions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryExtensionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCategoryExtensionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCategoryExtensions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryExtensionsResponse and nil error while calling GetCategoryExtensions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetCategoryExtensionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryExtensions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCategoryExtensionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCategoryExtensionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCategoryExtensions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryExtensionsResponse and nil error while calling GetCategoryExtensions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveDeleteCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCategoryResponse and nil error while calling DeleteCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCategoryResponse and nil error while calling DeleteCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveEditCategoryTranslation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEditCategoryTranslationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEditCategoryTranslationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveEditCategoryTranslationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EditCategoryTranslation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EditCategoryTranslationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EditCategoryTranslationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EditCategoryTranslation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EditCategoryTranslationResponse and nil error while calling EditCategoryTranslation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveEditCategoryTranslationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EditCategoryTranslation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EditCategoryTranslationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EditCategoryTranslationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EditCategoryTranslation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EditCategoryTranslationResponse and nil error while calling EditCategoryTranslation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveOrderCategories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOrderCategoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOrderCategoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveOrderCategoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OrderCategoriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrderCategoriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OrderCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrderCategoriesResponse and nil error while calling OrderCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveOrderCategoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OrderCategoriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrderCategoriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OrderCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrderCategoriesResponse and nil error while calling OrderCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddExtensionToCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddExtensionToCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddExtensionToCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddExtensionToCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddExtensionToCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddExtensionToCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddExtensionToCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddExtensionToCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddExtensionToCategoryResponse and nil error while calling AddExtensionToCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddExtensionToCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddExtensionToCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddExtensionToCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddExtensionToCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddExtensionToCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddExtensionToCategoryResponse and nil error while calling AddExtensionToCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveRemoveExtensionFromCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveExtensionFromCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveExtensionFromCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveRemoveExtensionFromCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveExtensionFromCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveExtensionFromCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveExtensionFromCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveExtensionFromCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveExtensionFromCategoryResponse and nil error while calling RemoveExtensionFromCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveRemoveExtensionFromCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveExtensionFromCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveExtensionFromCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveExtensionFromCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveExtensionFromCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveExtensionFromCategoryResponse and nil error while calling RemoveExtensionFromCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddCategoryToExtension(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddCategoryToExtensionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddCategoryToExtensionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddCategoryToExtensionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddCategoryToExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddCategoryToExtensionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddCategoryToExtensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddCategoryToExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddCategoryToExtensionResponse and nil error while calling AddCategoryToExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddCategoryToExtensionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddCategoryToExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddCategoryToExtensionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddCategoryToExtensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddCategoryToExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddCategoryToExtensionResponse and nil error while calling AddCategoryToExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveOrderCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOrderCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOrderCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveOrderCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OrderCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrderCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OrderCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrderCategoryResponse and nil error while calling OrderCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveOrderCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OrderCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OrderCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrderCategoryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OrderCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrderCategoryResponse and nil error while calling OrderCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddGameToExtension(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddGameToExtensionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddGameToExtensionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddGameToExtensionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddGameToExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddGameToExtensionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddGameToExtensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddGameToExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddGameToExtensionResponse and nil error while calling AddGameToExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddGameToExtensionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddGameToExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddGameToExtensionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddGameToExtensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddGameToExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddGameToExtensionResponse and nil error while calling AddGameToExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteGameFromExtension(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteGameFromExtensionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteGameFromExtensionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveDeleteGameFromExtensionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameFromExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteGameFromExtensionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteGameFromExtensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteGameFromExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteGameFromExtensionResponse and nil error while calling DeleteGameFromExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteGameFromExtensionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteGameFromExtension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteGameFromExtensionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteGameFromExtensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteGameFromExtension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteGameFromExtensionResponse and nil error while calling DeleteGameFromExtension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddFeaturedSchedule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddFeaturedScheduleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddFeaturedScheduleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddFeaturedScheduleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddFeaturedScheduleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFeaturedScheduleResponse and nil error while calling AddFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddFeaturedScheduleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddFeaturedScheduleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFeaturedScheduleResponse and nil error while calling AddFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedSchedules(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeaturedSchedulesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeaturedSchedulesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetFeaturedSchedulesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedules")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeaturedSchedulesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedSchedulesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedSchedules(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedSchedulesResponse and nil error while calling GetFeaturedSchedules. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedSchedulesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedules")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeaturedSchedulesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedSchedulesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedSchedules(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedSchedulesResponse and nil error while calling GetFeaturedSchedules. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateFeaturedSchedule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateFeaturedScheduleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateFeaturedScheduleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveUpdateFeaturedScheduleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateFeaturedScheduleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateFeaturedScheduleResponse and nil error while calling UpdateFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateFeaturedScheduleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateFeaturedScheduleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateFeaturedScheduleResponse and nil error while calling UpdateFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteFeaturedSchedule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteFeaturedScheduleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteFeaturedScheduleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveDeleteFeaturedScheduleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteFeaturedScheduleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeaturedScheduleResponse and nil error while calling DeleteFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteFeaturedScheduleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteFeaturedScheduleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeaturedScheduleResponse and nil error while calling DeleteFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedSchedule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeaturedScheduleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeaturedScheduleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetFeaturedScheduleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeaturedScheduleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedScheduleResponse and nil error while calling GetFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedScheduleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedSchedule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeaturedScheduleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedScheduleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedSchedule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedScheduleResponse and nil error while calling GetFeaturedSchedule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddFeaturedCarousel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddFeaturedCarouselJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddFeaturedCarouselProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddFeaturedCarouselJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddFeaturedCarouselRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFeaturedCarouselResponse and nil error while calling AddFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddFeaturedCarouselProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddFeaturedCarouselRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFeaturedCarouselResponse and nil error while calling AddFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarousels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeaturedCarouselsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeaturedCarouselsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetFeaturedCarouselsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeaturedCarouselsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarousels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselsResponse and nil error while calling GetFeaturedCarousels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarouselsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeaturedCarouselsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarousels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselsResponse and nil error while calling GetFeaturedCarousels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateFeaturedCarousel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateFeaturedCarouselJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateFeaturedCarouselProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveUpdateFeaturedCarouselJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateFeaturedCarouselRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateFeaturedCarouselResponse and nil error while calling UpdateFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateFeaturedCarouselProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateFeaturedCarouselRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateFeaturedCarouselResponse and nil error while calling UpdateFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteFeaturedCarousel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteFeaturedCarouselJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteFeaturedCarouselProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveDeleteFeaturedCarouselJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteFeaturedCarouselRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeaturedCarouselResponse and nil error while calling DeleteFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteFeaturedCarouselProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteFeaturedCarouselRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeaturedCarouselResponse and nil error while calling DeleteFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarousel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeaturedCarouselJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeaturedCarouselProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetFeaturedCarouselJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeaturedCarouselRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselResponse and nil error while calling GetFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarouselProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeaturedCarouselRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselResponse and nil error while calling GetFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveOrderFeaturedCarousel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOrderFeaturedCarouselJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOrderFeaturedCarouselProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveOrderFeaturedCarouselJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OrderFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OrderFeaturedCarouselRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrderFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OrderFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrderFeaturedCarouselResponse and nil error while calling OrderFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveOrderFeaturedCarouselProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OrderFeaturedCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OrderFeaturedCarouselRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrderFeaturedCarouselResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OrderFeaturedCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrderFeaturedCarouselResponse and nil error while calling OrderFeaturedCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddFeaturedCarouselEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddFeaturedCarouselEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddFeaturedCarouselEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveAddFeaturedCarouselEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddFeaturedCarouselEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFeaturedCarouselEntryResponse and nil error while calling AddFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveAddFeaturedCarouselEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddFeaturedCarouselEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFeaturedCarouselEntryResponse and nil error while calling AddFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarouselEntries(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeaturedCarouselEntriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeaturedCarouselEntriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetFeaturedCarouselEntriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeaturedCarouselEntriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselEntriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarouselEntries(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselEntriesResponse and nil error while calling GetFeaturedCarouselEntries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarouselEntriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeaturedCarouselEntriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselEntriesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarouselEntries(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselEntriesResponse and nil error while calling GetFeaturedCarouselEntries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateFeaturedCarouselEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateFeaturedCarouselEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateFeaturedCarouselEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveUpdateFeaturedCarouselEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateFeaturedCarouselEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateFeaturedCarouselEntryResponse and nil error while calling UpdateFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveUpdateFeaturedCarouselEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateFeaturedCarouselEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateFeaturedCarouselEntryResponse and nil error while calling UpdateFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteFeaturedCarouselEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteFeaturedCarouselEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteFeaturedCarouselEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveDeleteFeaturedCarouselEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteFeaturedCarouselEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeaturedCarouselEntryResponse and nil error while calling DeleteFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteFeaturedCarouselEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteFeaturedCarouselEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeaturedCarouselEntryResponse and nil error while calling DeleteFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarouselEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFeaturedCarouselEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFeaturedCarouselEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetFeaturedCarouselEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFeaturedCarouselEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselEntryResponse and nil error while calling GetFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetFeaturedCarouselEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFeaturedCarouselEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFeaturedCarouselEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFeaturedCarouselEntryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFeaturedCarouselEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFeaturedCarouselEntryResponse and nil error while calling GetFeaturedCarouselEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) servePutExtensionVersionDiscoveryData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutExtensionVersionDiscoveryDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutExtensionVersionDiscoveryDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) servePutExtensionVersionDiscoveryDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutExtensionVersionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutExtensionVersionDiscoveryDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PutExtensionVersionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.PutExtensionVersionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutExtensionVersionDiscoveryDataResponse and nil error while calling PutExtensionVersionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) servePutExtensionVersionDiscoveryDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutExtensionVersionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PutExtensionVersionDiscoveryDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PutExtensionVersionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.PutExtensionVersionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutExtensionVersionDiscoveryDataResponse and nil error while calling PutExtensionVersionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetExtensionVersionDiscoveryData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetExtensionVersionDiscoveryDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExtensionVersionDiscoveryDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveGetExtensionVersionDiscoveryDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionVersionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetExtensionVersionDiscoveryDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExtensionVersionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExtensionVersionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExtensionVersionDiscoveryDataResponse and nil error while calling GetExtensionVersionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveGetExtensionVersionDiscoveryDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionVersionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExtensionVersionDiscoveryDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExtensionVersionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExtensionVersionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExtensionVersionDiscoveryDataResponse and nil error while calling GetExtensionVersionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteExtensionVersionDiscoveryData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteExtensionVersionDiscoveryDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteExtensionVersionDiscoveryDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveDeleteExtensionVersionDiscoveryDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExtensionVersionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteExtensionVersionDiscoveryDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteExtensionVersionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteExtensionVersionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteExtensionVersionDiscoveryDataResponse and nil error while calling DeleteExtensionVersionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveDeleteExtensionVersionDiscoveryDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteExtensionVersionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteExtensionVersionDiscoveryDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteExtensionVersionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteExtensionVersionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteExtensionVersionDiscoveryDataResponse and nil error while calling DeleteExtensionVersionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveHardDeleteExtensionDiscoveryData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHardDeleteExtensionDiscoveryDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHardDeleteExtensionDiscoveryDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *discoveryServer) serveHardDeleteExtensionDiscoveryDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteExtensionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HardDeleteExtensionDiscoveryDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HardDeleteExtensionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HardDeleteExtensionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteExtensionDiscoveryDataResponse and nil error while calling HardDeleteExtensionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) serveHardDeleteExtensionDiscoveryDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteExtensionDiscoveryData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HardDeleteExtensionDiscoveryDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HardDeleteExtensionDiscoveryDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HardDeleteExtensionDiscoveryData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteExtensionDiscoveryDataResponse and nil error while calling HardDeleteExtensionDiscoveryData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *discoveryServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *discoveryServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3186 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x1b, 0xdd, 0x6f, 0x1c, 0x47,
	0xdd, 0xb3, 0xe7, 0xcf, 0x9f, 0x63, 0x3b, 0x4c, 0xed, 0xe4, 0xba, 0x49, 0x9c, 0x74, 0x53, 0xb5,
	0xa1, 0x45, 0xe7, 0x36, 0x2d, 0x25, 0x4d, 0x4d, 0xeb, 0x8f, 0x4b, 0x1c, 0x53, 0xb7, 0x49, 0xcf,
	0x4e, 0x8a, 0x9a, 0x0a, 0xba, 0xb9, 0x9b, 0x9c, 0xb7, 0xbd, 0xbb, 0x3d, 0x76, 0xf7, 0xdc, 0x1a,
	0x10, 0x08, 0x24, 0x50, 0x69, 0x51, 0x85, 0x40, 0xe2, 0x4b, 0xe5, 0x4b, 0x88, 0x0a, 0x24, 0x10,
	0x52, 0x1f, 0x78, 0x6f, 0x1f, 0x91, 0x78, 0xe3, 0x4f, 0xa8, 0xc4, 0x03, 0xef, 0x3c, 0xa3, 0xdd,
	0x9d, 0x9d, 0xdd, 0x99, 0xfd, 0x9a, 0xdd, 0xb3, 0xe3, 0xbc, 0x9c, 0x6e, 0x66, 0xe7, 0xf7, 0x9b,
	0xdf, 0xf7, 0x6f, 0x3e, 0x7e, 0x03, 0x0f, 0x35, 0xbb, 0xad, 0xa5, 0x96, 0x61, 0x37, 0xcd, 0x3d,
	0x62, 0xed, 0x2f, 0x59, 0xfd, 0x66, 0xd8, 0xaa, 0xf5, 0x2d, 0xd3, 0x31, 0xf1, 0xf9, 0xa6, 0xd9,
	0x22, 0xb5, 0x37, 0x07, 0xb6, 0x63, 0xf4, 0x6a, 0xce, 0x5e, 0x8d, 0xbc, 0xe3, 0x90, 0x9e, 0x6d,
	0x98, 0x3d, 0xbb, 0xc6, 0x86, 0xaa, 0x6b, 0x7b, 0xa4, 0xd7, 0x32, 0xad, 0xa5, 0xb6, 0xe1, 0xec,
	0x0e, 0xee, 0xd4, 0x9a, 0x66, 0x77, 0xa9, 0x6d, 0x76, 0xf4, 0x5e, 0x7b, 0xc9, 0x43, 0x72, 0x67,
	0x70, 0x77, 0xa9, 0xef, 0xec, 0xf7, 0x89, 0xbd, 0xe4, 0x18, 0x5d, 0x62, 0x3b, 0x7a, 0xb7, 0x1f,
	0xfe, 0xf3, 0x27, 0x52, 0x57, 0xa4, 0x71, 0xbc, 0x6d, 0xe9, 0xfd, 0x3e, 0xb1, 0xc2, 0x3f, 0x3e,
	0x06, 0x8d, 0x00, 0x5e, 0x6d, 0xb5, 0xd6, 0x75, 0x87, 0xb4, 0x4d, 0x6b, 0xbf, 0x41, 0xbe, 0x31,
	0x20, 0xb6, 0x83, 0xaf, 0xc3, 0x64, 0xd0, 0x55, 0x45, 0xe7, 0xd0, 0x85, 0xe9, 0x8b, 0x4f, 0xd5,
	0x24, 0x78, 0xaa, 0x05, 0x40, 0x37, 0xfb, 0x36, 0xb1, 0x9c, 0x06, 0x43, 0xa2, 0xfd, 0x4b, 0x81,
	0x59, 0xfe, 0x23, 0x7e, 0x12, 0xc6, 0xae, 0x5b, 0x2d, 0x62, 0xd1, 0x09, 0x4e, 0xd5, 0xda, 0xa6,
	0xd9, 0xee, 0x90, 0x5a, 0x40, 0x79, 0xed, 0x6a, 0xc7, 0xd4, 0x9d, 0x5b, 0x7a, 0x67, 0x40, 0x1a,
	0xfe, 0x48, 0xfc, 0x0c, 0x4c, 0x36, 0x88, 0xde, 0x32, 0x7b, 0x9d, 0xfd, 0xaa, 0xe2, 0x41, 0xa9,
	0x31, 0xa8, 0x35, 0xd3, 0xec, 0xf8, 0x40, 0x6c, 0x2c, 0x7e, 0x02, 0x46, 0xb7, 0x3b, 0x83, 0x76,
	0xb5, 0xe2, 0xc1, 0x9c, 0x8e, 0xc1, 0x6c, 0x3b, 0x96, 0xd1, 0x6b, 0xfb, 0x50, 0xde, 0x48, 0xfc,
	0x0c, 0x4c, 0x6c, 0x9b, 0x96, 0xf3, 0x22, 0xd9, 0xaf, 0x8e, 0x4a, 0x00, 0x05, 0x83, 0xdd, 0x99,
	0x76, 0xf6, 0xfb, 0xa4, 0x3a, 0x26, 0x33, 0x93, 0x3b, 0x12, 0x3f, 0x0d, 0x13, 0xb7, 0x0c, 0xdb,
	0xb8, 0xd3, 0x21, 0xd5, 0xf1, 0x5c, 0x96, 0x82, 0xa1, 0xda, 0x2e, 0x3c, 0xc0, 0xa9, 0xcd, 0xee,
	0x9b, 0x3d, 0x9b, 0xe0, 0x57, 0x62, 0x7a, 0xfb, 0x62, 0x21, 0xbd, 0xd5, 0xcd, 0xe6, 0xa0, 0x4b,
	0x7a, 0x51, 0xcd, 0xfd, 0x56, 0x81, 0xe3, 0xe2, 0x67, 0x3c, 0x0b, 0xca, 0x66, 0xdd, 0x9b, 0x61,
	0xaa, 0xa1, 0x6c, 0xd6, 0x31, 0xa6, 0x6c, 0x2b, 0x5e, 0x8f, 0xcf, 0xd8, 0x7c, 0xa0, 0x5f, 0x57,
	0xea, 0x4a, 0xa0, 0xc2, 0x40, 0x15, 0xa3, 0xd2, 0xaa, 0xa8, 0x86, 0xaa, 0x18, 0xf3, 0xd0, 0x33,
	0x61, 0xab, 0x11, 0x73, 0x70, 0x65, 0x37, 0x19, 0x51, 0x79, 0x35, 0x14, 0xeb, 0x84, 0xf7, 0x29,
	0x68, 0xba, 0x5f, 0xea, 0xa4, 0x43, 0x1c, 0xd2, 0xaa, 0x4e, 0xfa, 0x5f, 0x68, 0xd3, 0xe5, 0xe2,
	0x65, 0xbd, 0x4b, 0xaa, 0x53, 0x3e, 0x17, 0xee, 0x7f, 0x7c, 0x0e, 0xa6, 0xeb, 0xc4, 0x6e, 0x5a,
	0x46, 0xdf, 0x31, 0xcc, 0x5e, 0x15, 0xbc, 0x4f, 0xd1, 0x2e, 0xed, 0x53, 0x04, 0xf3, 0x1b, 0xc4,
	0xa1, 0x32, 0x32, 0x88, 0x1d, 0x38, 0xd1, 0x3c, 0x8c, 0x6d, 0x19, 0x5d, 0xc3, 0xf1, 0xe4, 0x34,
	0xd6, 0xf0, 0x1b, 0xf8, 0x04, 0x8c, 0x5f, 0xbf, 0x7b, 0xd7, 0x26, 0x8e, 0x27, 0xac, 0xb1, 0x06,
	0x6d, 0x31, 0x11, 0x56, 0x22, 0x22, 0x7c, 0x18, 0x66, 0x36, 0x7b, 0xcd, 0xce, 0xa0, 0x45, 0xae,
	0x19, 0xad, 0x16, 0xe9, 0x79, 0x52, 0x9b, 0x6c, 0xf0, 0x9d, 0xf8, 0x11, 0x98, 0xa5, 0x1d, 0x01,
	0x5f, 0x63, 0xde, 0x30, 0xa1, 0xd7, 0x15, 0xd7, 0x96, 0xde, 0x6b, 0x0f, 0xf4, 0xb6, 0x6f, 0x6a,
	0x53, 0x0d, 0xd6, 0xd6, 0xfa, 0xb0, 0x20, 0xf0, 0x40, 0x2d, 0xea, 0x55, 0x80, 0xb0, 0x97, 0xda,
	0xd4, 0x97, 0x8a, 0xd8, 0x94, 0x41, 0x6c, 0x66, 0x55, 0x11, 0x54, 0xda, 0xf7, 0x10, 0xe0, 0xf8,
	0x10, 0x57, 0x68, 0xeb, 0xe6, 0xa0, 0xc7, 0x84, 0xe6, 0x35, 0xf0, 0x4d, 0x8e, 0x0a, 0xe5, 0x5c,
	0xa5, 0xbc, 0x65, 0x47, 0x69, 0x78, 0x17, 0xc1, 0xc2, 0xcd, 0x7e, 0x4b, 0x77, 0x88, 0x18, 0x00,
	0x17, 0xd9, 0x84, 0xfb, 0xcc, 0xd0, 0x23, 0x3d, 0x5c, 0x80, 0x54, 0x0e, 0x22, 0x40, 0xbe, 0x05,
	0x27, 0x44, 0x4a, 0x0e, 0xcf, 0xa7, 0x6f, 0x00, 0x0e, 0xb5, 0x2d, 0xcd, 0x73, 0xd4, 0x7e, 0x14,
	0xc1, 0x7e, 0x76, 0xe1, 0x01, 0x0e, 0xe3, 0xe1, 0xd1, 0xfe, 0x43, 0x04, 0xa7, 0x23, 0x53, 0x5d,
	0x61, 0xe0, 0xb2, 0x6c, 0x44, 0xe2, 0x89, 0xc2, 0xc7, 0x13, 0xe6, 0xb0, 0x95, 0x64, 0x87, 0x1d,
	0x8d, 0x3a, 0xac, 0xf6, 0x13, 0x04, 0x67, 0x52, 0x08, 0xa1, 0xdc, 0x9b, 0xcc, 0xc2, 0x23, 0x5f,
	0xa9, 0x1c, 0x5e, 0x28, 0x24, 0x87, 0x10, 0x9c, 0x49, 0x24, 0x01, 0xb5, 0xf6, 0x32, 0xa8, 0xe9,
	0x10, 0xf8, 0x38, 0x54, 0x36, 0xeb, 0xee, 0xfc, 0x95, 0x0b, 0x53, 0x0d, 0xf7, 0xaf, 0x2b, 0xaa,
	0x1d, 0xd3, 0xd1, 0x3b, 0xbe, 0xc7, 0xf9, 0xf1, 0x28, 0xd2, 0xa3, 0xbd, 0x0a, 0x0b, 0x7e, 0xf0,
	0x28, 0x6a, 0x2a, 0x8b, 0x00, 0xdb, 0xe6, 0x5d, 0xc7, 0x07, 0xf6, 0x10, 0x4f, 0x36, 0x22, 0x3d,
	0xae, 0xb5, 0x8b, 0x88, 0x0f, 0xcf, 0x62, 0x7e, 0x8a, 0x60, 0xf1, 0x4a, 0xcb, 0x60, 0x9a, 0xda,
	0xb1, 0xf4, 0x9e, 0xdd, 0xd1, 0xdd, 0xe0, 0x7d, 0x00, 0xa6, 0xcf, 0xb2, 0x46, 0x25, 0x3d, 0x6b,
	0x8c, 0xc6, 0xb3, 0x86, 0x03, 0x67, 0x53, 0x69, 0x3a, 0x3c, 0x51, 0x5c, 0x82, 0x13, 0x5e, 0x1a,
	0x8e, 0x27, 0xab, 0x45, 0x21, 0xce, 0x57, 0x22, 0x12, 0x70, 0x43, 0xe5, 0xb7, 0xe0, 0x64, 0x0c,
	0x92, 0xd2, 0xf9, 0x06, 0xcc, 0x04, 0x13, 0x44, 0x17, 0x74, 0x97, 0x0b, 0x11, 0xeb, 0x41, 0x32,
	0x8a, 0x79, 0x84, 0x9a, 0x03, 0x0b, 0x89, 0xe3, 0xf0, 0xed, 0xf8, 0xd4, 0x43, 0xa4, 0x06, 0x61,
	0xd6, 0x8f, 0x14, 0x38, 0xb3, 0xda, 0x6a, 0x31, 0x4f, 0xda, 0x31, 0x45, 0x37, 0x38, 0x07, 0xd3,
	0xec, 0x2b, 0xb3, 0x9b, 0x68, 0x17, 0xbe, 0x0c, 0x53, 0xb7, 0x88, 0x45, 0xbf, 0x2b, 0x12, 0x6b,
	0x9e, 0x70, 0xb8, 0x60, 0x94, 0x95, 0x98, 0x51, 0x5e, 0x82, 0xa9, 0x6d, 0x47, 0xb7, 0x9c, 0x1d,
	0xa3, 0x4b, 0xe8, 0x7a, 0x2a, 0xbe, 0x76, 0xdc, 0x09, 0x76, 0x0c, 0x8d, 0x70, 0x70, 0xb8, 0xf4,
	0x1e, 0x93, 0x5e, 0x7a, 0x67, 0x2d, 0x1e, 0xfe, 0x86, 0x60, 0x31, 0x4d, 0x50, 0xd4, 0x46, 0xde,
	0x43, 0x70, 0x8a, 0x7d, 0x0f, 0xbe, 0xbe, 0x44, 0xba, 0x77, 0x88, 0x65, 0xef, 0x1a, 0x7d, 0x6a,
	0x32, 0xd7, 0xa4, 0xf4, 0x96, 0x81, 0x87, 0xa9, 0x32, 0x6b, 0x32, 0xed, 0xdf, 0x08, 0xce, 0x4b,
	0x20, 0x91, 0x50, 0x2f, 0xaf, 0x22, 0x25, 0x5b, 0x45, 0x95, 0x52, 0x2a, 0x1a, 0x95, 0x55, 0x91,
	0x76, 0x17, 0xb4, 0x06, 0xe9, 0x9a, 0x7b, 0x84, 0x51, 0x78, 0xd5, 0x32, 0xbb, 0xc5, 0x6d, 0x36,
	0x87, 0x29, 0xed, 0x63, 0x04, 0xe7, 0x33, 0x27, 0xba, 0x1f, 0x75, 0xfe, 0x5d, 0xcf, 0x97, 0x59,
	0xb8, 0x35, 0xd9, 0x58, 0x79, 0xb9, 0x9c, 0x16, 0x7d, 0x79, 0xaa, 0x80, 0xb7, 0x06, 0x4e, 0x92,
	0x48, 0xc1, 0xfd, 0x28, 0xb0, 0x5b, 0x30, 0x1f, 0x0d, 0xf8, 0x45, 0x52, 0x7f, 0x64, 0xb1, 0xa3,
	0xf8, 0x89, 0x24, 0xb2, 0x46, 0x79, 0x13, 0x16, 0x04, 0xbc, 0x87, 0x97, 0xee, 0x6c, 0x78, 0x70,
	0xb5, 0xd5, 0xda, 0xd0, 0xbb, 0xe4, 0x10, 0x14, 0x7e, 0x02, 0xc6, 0x5d, 0xcc, 0x54, 0xd9, 0x63,
	0x0d, 0xda, 0xd2, 0x3e, 0x44, 0xa0, 0x26, 0xcd, 0x4a, 0xd9, 0xfc, 0x0e, 0x9c, 0x64, 0x9d, 0xee,
	0x98, 0x98, 0x7e, 0xeb, 0xc5, 0xf4, 0xcb, 0xe3, 0x60, 0x42, 0x48, 0x9b, 0x44, 0xbb, 0x0d, 0x67,
	0x73, 0x60, 0x25, 0x24, 0x13, 0xf2, 0xae, 0x70, 0xbc, 0xbf, 0x03, 0x8b, 0xfe, 0xba, 0xce, 0x6d,
	0xbb, 0x41, 0xe1, 0x9e, 0x49, 0xfd, 0x0f, 0x08, 0xce, 0xa6, 0x4e, 0x7d, 0x9f, 0x88, 0xfe, 0x07,
	0xbe, 0x65, 0x5c, 0x25, 0xba, 0x33, 0xb0, 0x48, 0x6b, 0xbb, 0xb9, 0x4b, 0x5a, 0x83, 0x0e, 0x09,
	0x44, 0xd3, 0x86, 0xe3, 0xe2, 0x27, 0x4a, 0xd7, 0x73, 0x52, 0x74, 0x89, 0xc0, 0x74, 0x8f, 0x19,
	0x43, 0xaa, 0x75, 0xe0, 0x44, 0xf2, 0x58, 0x71, 0xdd, 0x8a, 0x62, 0xeb, 0x56, 0x76, 0x7e, 0xa3,
	0xc8, 0x9e, 0xdf, 0xb8, 0x9b, 0xec, 0x53, 0x89, 0x5c, 0x53, 0xad, 0x18, 0xa9, 0x6c, 0x7f, 0xb9,
	0x14, 0xdb, 0x4c, 0x0f, 0x71, 0xc6, 0xff, 0x83, 0xa0, 0x9a, 0x36, 0x3c, 0x76, 0xa6, 0x25, 0xc8,
	0x42, 0x49, 0x97, 0x85, 0xfc, 0xb1, 0x62, 0x1b, 0xe6, 0xd6, 0x07, 0x96, 0x45, 0x7a, 0xce, 0xba,
	0x6e, 0x99, 0x03, 0x9b, 0x74, 0x68, 0x7e, 0x2f, 0xc6, 0x6a, 0x00, 0xcc, 0x58, 0x15, 0xb1, 0x6a,
	0x1f, 0x20, 0x78, 0x50, 0xe4, 0x34, 0xef, 0x90, 0xe5, 0x36, 0x4c, 0xb1, 0xa1, 0xf4, 0x8c, 0x65,
	0x48, 0x0d, 0x84, 0xf8, 0xb4, 0x17, 0xe1, 0xd4, 0x06, 0x71, 0x62, 0x24, 0x05, 0xb6, 0x1f, 0x6e,
	0xb2, 0x11, 0x77, 0x2a, 0xc6, 0xb6, 0xe4, 0x4a, 0x64, 0x4b, 0xae, 0x7d, 0xdb, 0x3b, 0x02, 0x48,
	0x40, 0x46, 0x4d, 0xea, 0xf5, 0x28, 0x27, 0xbe, 0x2d, 0x3d, 0x5f, 0x8a, 0x13, 0x3b, 0x89, 0x95,
	0x3f, 0x23, 0x38, 0xe3, 0x9f, 0xd5, 0xa4, 0x79, 0xb2, 0xbb, 0xfd, 0xa5, 0x5d, 0x61, 0x8e, 0x0c,
	0x7b, 0x12, 0x3d, 0x5d, 0x39, 0x0c, 0x4f, 0x7f, 0x1f, 0xc1, 0x62, 0x1a, 0xa9, 0xf7, 0xde, 0xfd,
	0x5e, 0x80, 0x33, 0x7e, 0x88, 0x2e, 0x29, 0x37, 0x8f, 0x9d, 0x34, 0x0c, 0xf7, 0x9e, 0x9d, 0x65,
	0x50, 0x13, 0xac, 0x50, 0x96, 0x17, 0x37, 0x2c, 0x26, 0x82, 0xdf, 0x7b, 0x46, 0x84, 0xbc, 0x14,
	0x04, 0x91, 0x84, 0xbc, 0xc4, 0xa2, 0x56, 0x99, 0xbc, 0x14, 0x00, 0x8b, 0xd6, 0xca, 0x82, 0x96,
	0x15, 0xe6, 0x25, 0x7e, 0x6c, 0xae, 0x43, 0x71, 0xfb, 0x2c, 0xa5, 0xc0, 0x3e, 0x4b, 0xcc, 0x4e,
	0x21, 0xef, 0x71, 0x35, 0x08, 0xcc, 0x0f, 0x19, 0xb2, 0xe3, 0xec, 0x7f, 0x16, 0xc9, 0x4e, 0xe2,
	0xf0, 0x58, 0x76, 0xe2, 0x25, 0xa2, 0x64, 0x4b, 0xa4, 0xd0, 0xce, 0xf3, 0x6b, 0x30, 0x71, 0xa5,
	0xe7, 0x78, 0xc7, 0x40, 0xa3, 0x05, 0x56, 0x45, 0x22, 0xe5, 0x14, 0x07, 0xe3, 0x37, 0x40, 0xaa,
	0xfd, 0x09, 0xc1, 0xd9, 0x9c, 0xc1, 0x29, 0x09, 0xaa, 0x03, 0x73, 0x02, 0x00, 0x4d, 0x53, 0x6b,
	0xa5, 0x29, 0xdc, 0x8f, 0xa4, 0x50, 0x1e, 0xb5, 0x90, 0xb1, 0x82, 0xaf, 0x25, 0x33, 0xd6, 0x8f,
	0x11, 0x97, 0xb2, 0x22, 0xd8, 0xa8, 0x9d, 0x75, 0xe0, 0x73, 0xb1, 0x8f, 0xa5, 0x52, 0x17, 0x83,
	0x66, 0x9c, 0xc5, 0x11, 0x73, 0xcb, 0x83, 0x18, 0x40, 0xfa, 0xf2, 0x20, 0xa4, 0xac, 0xcc, 0xf2,
	0x20, 0xe6, 0x02, 0x21, 0xbe, 0x84, 0x9c, 0x2a, 0x46, 0x21, 0x6f, 0xdf, 0xe9, 0x77, 0x45, 0xf7,
	0x9d, 0x41, 0x4f, 0x62, 0x94, 0x52, 0x0e, 0x23, 0x4a, 0xc5, 0x73, 0xea, 0x51, 0x06, 0x8d, 0x58,
	0x4e, 0x2d, 0x28, 0xb7, 0x84, 0x9c, 0x7a, 0x94, 0xec, 0xf0, 0x39, 0xb5, 0x28, 0x2f, 0x42, 0x4e,
	0x3d, 0x4a, 0x46, 0x5e, 0x83, 0xd3, 0xde, 0x31, 0x47, 0x59, 0x73, 0x56, 0x61, 0xd2, 0x8b, 0x4f,
	0x9b, 0xf5, 0xe0, 0x10, 0x85, 0xb5, 0xb5, 0xf7, 0x10, 0x9c, 0x49, 0x41, 0x7e, 0xef, 0x19, 0xfd,
	0x15, 0x82, 0xb3, 0x09, 0x09, 0xd4, 0x23, 0x36, 0x60, 0x76, 0x0f, 0x16, 0x12, 0xbf, 0x53, 0x9a,
	0x56, 0xca, 0x87, 0x6f, 0xea, 0xa5, 0xc9, 0xe8, 0xb5, 0xff, 0x22, 0x38, 0x95, 0x01, 0x86, 0x97,
	0x63, 0x4a, 0xc8, 0xdb, 0xc6, 0x45, 0x55, 0x74, 0x1b, 0x26, 0xd6, 0xcd, 0x9e, 0x43, 0xe8, 0xd5,
	0xd9, 0xf4, 0xc5, 0xd5, 0xf2, 0x7c, 0x50, 0x44, 0x8d, 0x00, 0x63, 0x78, 0xfe, 0x5b, 0x91, 0x3e,
	0xff, 0x75, 0xe0, 0x74, 0x16, 0x6e, 0xac, 0xc1, 0xb1, 0xf5, 0x8e, 0xd1, 0x7c, 0x6b, 0x67, 0xd7,
	0x32, 0x07, 0xed, 0x5d, 0x6a, 0x74, 0x5c, 0x9f, 0x6b, 0x76, 0x9b, 0x5d, 0xbd, 0x4d, 0x6e, 0x36,
	0xb6, 0x82, 0x8b, 0xae, 0xa0, 0xed, 0xa6, 0x85, 0x1d, 0xc3, 0xe9, 0x04, 0x37, 0x5d, 0x7e, 0x43,
	0xfb, 0x10, 0xc1, 0xb9, 0x74, 0xfd, 0x53, 0x7b, 0x7c, 0x27, 0xdb, 0x00, 0x0e, 0x22, 0x7f, 0xa7,
	0x98, 0xc0, 0xa7, 0x08, 0xce, 0x64, 0x02, 0x26, 0xad, 0xac, 0x22, 0x46, 0xa1, 0xc4, 0x3c, 0x33,
	0xa2, 0xf6, 0xca, 0x81, 0xab, 0x7d, 0x3e, 0x7a, 0xec, 0x1f, 0x14, 0xcd, 0x68, 0xaf, 0xc0, 0x43,
	0x09, 0x61, 0x8d, 0x2e, 0x54, 0xca, 0x2d, 0x48, 0x7e, 0x89, 0x40, 0xcb, 0xc2, 0x49, 0x15, 0x97,
	0xbc, 0x14, 0x78, 0x3d, 0x5c, 0x22, 0x1e, 0xdc, 0x02, 0x8c, 0x2d, 0x10, 0xff, 0x8a, 0x40, 0x4b,
	0x4e, 0xb0, 0x5c, 0x50, 0x11, 0xf5, 0x96, 0x1a, 0x64, 0x94, 0xc3, 0x0d, 0x32, 0xbf, 0x43, 0x70,
	0x3e, 0x93, 0xdc, 0x23, 0xf7, 0x81, 0xa7, 0x41, 0x4b, 0xce, 0xf0, 0x59, 0xf2, 0xf4, 0xf8, 0xca,
	0x04, 0x3b, 0x72, 0xbe, 0x9e, 0x84, 0xb3, 0x29, 0x26, 0x9c, 0xca, 0x94, 0x1b, 0xad, 0xd2, 0x61,
	0x8e, 0x9c, 0xa3, 0x9f, 0x23, 0x78, 0xcc, 0xb7, 0x25, 0x76, 0x86, 0x4c, 0x8f, 0xbe, 0xeb, 0x01,
	0xe2, 0xba, 0xee, 0xe8, 0x01, 0x77, 0xbb, 0x00, 0xfe, 0x68, 0xb7, 0xb3, 0xdc, 0xf5, 0x50, 0x12,
	0x7a, 0x1f, 0x67, 0x23, 0x82, 0x5b, 0xfb, 0x19, 0x82, 0x47, 0x6f, 0x0c, 0x9c, 0xfb, 0x8c, 0xaa,
	0x8f, 0x10, 0x5c, 0xc8, 0xa7, 0x8a, 0x6a, 0xf5, 0x9b, 0x30, 0x1f, 0x1b, 0x18, 0x12, 0x78, 0x75,
	0x48, 0x02, 0x03, 0xc5, 0x26, 0xce, 0xa1, 0x11, 0x78, 0x74, 0x83, 0xc8, 0x49, 0x2f, 0xff, 0x82,
	0xa4, 0x0a, 0x13, 0x14, 0x41, 0x50, 0xc0, 0x44, 0x9b, 0x9e, 0x3c, 0xf2, 0xe7, 0xb9, 0x0f, 0xe4,
	0xb1, 0x0b, 0x8f, 0xf9, 0xa1, 0xe5, 0xd0, 0x45, 0xb2, 0x01, 0x8f, 0x4b, 0xcd, 0x44, 0x85, 0x52,
	0x85, 0x09, 0x7b, 0xd0, 0x6c, 0x12, 0xdb, 0xdf, 0x7c, 0x4f, 0x36, 0x82, 0xa6, 0xf6, 0x22, 0x3c,
	0x7a, 0x4d, 0xb7, 0x5a, 0x02, 0xb2, 0x72, 0xf4, 0x6a, 0x75, 0xb8, 0x90, 0x8f, 0x2c, 0x97, 0xa4,
	0xff, 0x4d, 0x46, 0xea, 0x18, 0xd2, 0x5d, 0x66, 0x18, 0xf9, 0xe1, 0x27, 0x22, 0xd5, 0x4d, 0xb9,
	0x77, 0x1c, 0x5e, 0xed, 0xd3, 0x32, 0xc0, 0xea, 0xc0, 0xd9, 0x35, 0x2d, 0x0f, 0x4e, 0xa6, 0xce,
	0x37, 0x32, 0x5e, 0xa8, 0x37, 0x1d, 0x2b, 0x50, 0x6f, 0x7a, 0xdd, 0xbb, 0x94, 0xd1, 0x3b, 0x3e,
	0xe6, 0x2d, 0xc3, 0xe6, 0x6a, 0x3d, 0xf1, 0xf3, 0xfc, 0x75, 0xce, 0xb8, 0x04, 0x5d, 0xdc, 0x65,
	0xcf, 0x32, 0xc0, 0x95, 0x9b, 0x5b, 0xab, 0x3b, 0xd7, 0xb7, 0xdd, 0xb5, 0xf1, 0x84, 0x0c, 0x5b,
	0xe1, 0x78, 0xfc, 0x15, 0x18, 0xdb, 0xd0, 0xbb, 0xc4, 0xf6, 0x4a, 0x8e, 0xa7, 0x2f, 0x3e, 0x5d,
	0x88, 0xa3, 0xcd, 0x9e, 0xe3, 0xb1, 0xe3, 0xa3, 0xc0, 0xaf, 0xc1, 0xd4, 0x66, 0xd3, 0xec, 0xdd,
	0xd0, 0x9d, 0x5d, 0xdb, 0xab, 0x55, 0x9e, 0xbe, 0xb8, 0x5c, 0x42, 0x42, 0xfe, 0xef, 0x4b, 0x7a,
	0xbf, 0x11, 0xa2, 0xc3, 0x5f, 0x85, 0x49, 0xb7, 0x71, 0xb3, 0xb1, 0x65, 0x7b, 0xb5, 0xce, 0xc3,
	0xa2, 0x66, 0xd8, 0xf0, 0x35, 0x38, 0x7e, 0xc3, 0x32, 0xf6, 0xf4, 0xe6, 0xfe, 0x0d, 0xb3, 0x63,
	0x34, 0xf7, 0x5d, 0x29, 0x4e, 0x4b, 0x48, 0x31, 0x06, 0x85, 0x75, 0x98, 0xdb, 0x6e, 0x5a, 0x84,
	0xf4, 0xec, 0x5d, 0xd3, 0xf1, 0xa5, 0x70, 0x6c, 0x38, 0x3b, 0x11, 0xf1, 0xe1, 0xaf, 0xc3, 0x6c,
	0xd8, 0xe5, 0x09, 0x63, 0x66, 0xb8, 0x19, 0x04, 0x74, 0xde, 0xfb, 0x82, 0x41, 0xb7, 0xab, 0x5b,
	0xfb, 0xd5, 0x59, 0xa9, 0xf7, 0x05, 0xfe, 0x60, 0xbc, 0x02, 0xc7, 0xb6, 0x07, 0xfd, 0xbe, 0x69,
	0x39, 0x57, 0xba, 0xba, 0xd1, 0xa9, 0xce, 0x49, 0x00, 0x73, 0x10, 0x78, 0x0d, 0x66, 0x6e, 0x19,
	0xe4, 0x6d, 0x62, 0x05, 0xf3, 0x1f, 0x97, 0x40, 0xc1, 0x83, 0x68, 0x5f, 0x00, 0x1c, 0xe7, 0xd1,
	0xdd, 0x80, 0x78, 0xa3, 0x83, 0xf2, 0x41, 0xda, 0xd2, 0x3e, 0x0f, 0x73, 0x82, 0x25, 0x0b, 0x43,
	0x2b, 0x6c, 0xe8, 0x3f, 0x10, 0x9c, 0x4c, 0x31, 0x25, 0xfc, 0x06, 0x07, 0x23, 0xbb, 0xa4, 0x48,
	0xc1, 0x56, 0xf3, 0x51, 0xf9, 0xeb, 0x3e, 0x8a, 0x57, 0x7d, 0x16, 0xa6, 0x23, 0xdd, 0xf8, 0x38,
	0x54, 0xde, 0x22, 0xfb, 0x34, 0x5c, 0xba, 0x7f, 0xdd, 0xdd, 0xd0, 0x9e, 0x3b, 0x80, 0x06, 0x49,
	0xbf, 0x71, 0x59, 0xb9, 0x84, 0xb4, 0x4f, 0x10, 0x3c, 0x94, 0x9b, 0x0c, 0x87, 0x0a, 0xc4, 0x6f,
	0xc0, 0x0c, 0x17, 0xdb, 0x69, 0x44, 0x96, 0xab, 0xb2, 0xe4, 0x20, 0xc3, 0x7a, 0x47, 0xae, 0x5b,
	0xfb, 0xd1, 0x38, 0x2c, 0x24, 0x0e, 0x64, 0x25, 0xae, 0x28, 0x52, 0xe2, 0xba, 0xc8, 0x85, 0x79,
	0xba, 0x4d, 0x8e, 0x04, 0x72, 0xbe, 0xa0, 0xb4, 0x22, 0x16, 0x94, 0xe6, 0x97, 0xc8, 0x7a, 0x95,
	0x44, 0x61, 0xc4, 0xf5, 0xdf, 0x7e, 0x44, 0x63, 0xea, 0x7c, 0x10, 0x53, 0xc7, 0x3d, 0x1b, 0xa2,
	0xd1, 0xb1, 0x1d, 0x8d, 0x8e, 0x13, 0x9e, 0xa5, 0x6c, 0x96, 0x97, 0x51, 0x8d, 0xe1, 0xf2, 0x4d,
	0x25, 0x12, 0x2a, 0x5b, 0x91, 0x50, 0x39, 0x59, 0xc0, 0x22, 0xd3, 0xe7, 0x71, 0x51, 0xf9, 0xd3,
	0x84, 0x61, 0xf3, 0xb1, 0x84, 0xb0, 0xe9, 0xbf, 0x4f, 0x89, 0x07, 0xc6, 0x0b, 0xf1, 0xc0, 0x08,
	0x9e, 0xdc, 0x63, 0xf1, 0xed, 0x91, 0x58, 0x7c, 0x9b, 0xf6, 0x06, 0x8a, 0x61, 0xaa, 0x1a, 0x86,
	0xa9, 0x63, 0xb4, 0x56, 0x9e, 0x06, 0x22, 0x4d, 0x08, 0x44, 0x33, 0xfe, 0x61, 0x12, 0x17, 0x6a,
	0x1e, 0x16, 0x43, 0xcd, 0xac, 0x37, 0x88, 0xef, 0x8c, 0xbe, 0xc7, 0x99, 0xe3, 0xde, 0xe3, 0xa8,
	0xcb, 0x30, 0xcb, 0x8b, 0xbf, 0x88, 0x4b, 0xaa, 0xcf, 0xc1, 0x0c, 0x27, 0xd4, 0x22, 0xc0, 0x17,
	0x3f, 0x7b, 0x1c, 0xa6, 0x98, 0xa2, 0xf0, 0xf7, 0x11, 0x4c, 0x47, 0x6a, 0xf7, 0xb0, 0x5c, 0x1a,
	0x88, 0xbf, 0xab, 0x53, 0x2f, 0x15, 0x07, 0xf4, 0x57, 0x81, 0xda, 0x08, 0x7e, 0x17, 0xc1, 0x0c,
	0xf7, 0x46, 0x07, 0x3f, 0x2b, 0x85, 0x2d, 0xe9, 0x6d, 0x92, 0x7a, 0xb9, 0x0c, 0x28, 0x23, 0xe5,
	0x7d, 0x04, 0xb3, 0xfc, 0x6b, 0x15, 0x2c, 0x87, 0x30, 0xf1, 0xb1, 0x8d, 0xfa, 0x5c, 0x29, 0x58,
	0x46, 0x8d, 0xab, 0x9d, 0xc8, 0x43, 0x0c, 0x49, 0xed, 0xc4, 0x1f, 0xc0, 0x48, 0x6a, 0x27, 0xe1,
	0x9d, 0x8b, 0x36, 0x82, 0x7f, 0x8f, 0xa2, 0x2f, 0xa8, 0x22, 0xcf, 0x2f, 0xf0, 0x6a, 0x51, 0xac,
	0xb1, 0x27, 0x2d, 0xea, 0xda, 0x30, 0x28, 0x38, 0xad, 0xf1, 0xaf, 0x2e, 0x24, 0xb5, 0x96, 0xf8,
	0x06, 0x44, 0x52, 0x6b, 0xc9, 0xcf, 0x3c, 0xb4, 0x11, 0xfc, 0x11, 0x82, 0x93, 0x29, 0x2f, 0x20,
	0xf0, 0xba, 0xdc, 0xe6, 0x33, 0xf3, 0x4d, 0x87, 0x5a, 0x1f, 0x0e, 0x09, 0x23, 0xf4, 0x03, 0x04,
	0x73, 0xc2, 0xd3, 0x07, 0x2c, 0xc7, 0x7b, 0xf2, 0x53, 0x0b, 0x75, 0xb9, 0x1c, 0x30, 0x23, 0xe8,
	0x8f, 0x08, 0x4e, 0x24, 0x97, 0xdb, 0xe3, 0x35, 0xd9, 0xf8, 0x92, 0xfe, 0xa8, 0x41, 0x5d, 0x1f,
	0x0a, 0x07, 0xa3, 0xf2, 0x63, 0x04, 0xa7, 0x32, 0xaa, 0xc4, 0xf1, 0x86, 0xd4, 0x34, 0xf9, 0x05,
	0xed, 0xea, 0xb5, 0xe1, 0x11, 0x89, 0xa2, 0x4d, 0x28, 0xd2, 0x96, 0x17, 0x6d, 0x7a, 0x8d, 0xb9,
	0xbc, 0x68, 0x33, 0xaa, 0xc4, 0x69, 0x26, 0xe0, 0x6a, 0xa8, 0x25, 0x33, 0x41, 0x52, 0x3d, 0xb7,
	0x64, 0x26, 0x48, 0x2c, 0xd9, 0xd6, 0x46, 0xf0, 0x2f, 0x90, 0xf7, 0x7e, 0x5c, 0x28, 0x76, 0xc6,
	0xcf, 0xcb, 0x32, 0x9a, 0x5c, 0x9b, 0xad, 0xbe, 0x50, 0x1a, 0x9e, 0x8b, 0x2f, 0x29, 0x05, 0xc1,
	0x92, 0xf1, 0x25, 0xbb, 0x92, 0x59, 0x32, 0xbe, 0xe4, 0xd4, 0x24, 0x6b, 0x23, 0xf8, 0xd7, 0xc8,
	0x7b, 0xcb, 0x2d, 0x56, 0x65, 0x61, 0x69, 0x19, 0xa4, 0x54, 0xa0, 0xa9, 0x2b, 0xe5, 0x11, 0x30,
	0xe2, 0x7e, 0xe3, 0x3f, 0x6e, 0x8e, 0xd5, 0x45, 0xe2, 0x15, 0xd9, 0x94, 0x94, 0x56, 0xf2, 0xa9,
	0xae, 0x0e, 0x81, 0x81, 0x73, 0xd8, 0xe4, 0x02, 0x47, 0x49, 0x87, 0xcd, 0x2c, 0xe4, 0x94, 0x74,
	0xd8, 0xec, 0x0a, 0x4b, 0x4a, 0x65, 0x72, 0xdd, 0xa2, 0x24, 0x95, 0x99, 0x65, 0x93, 0xea, 0xfa,
	0x50, 0x38, 0x38, 0x43, 0x4c, 0x10, 0xb7, 0xa4, 0x21, 0xa6, 0x97, 0x42, 0xaa, 0x2b, 0xe5, 0x11,
	0xa4, 0x79, 0x49, 0x70, 0x6d, 0x52, 0xdc, 0x4b, 0x84, 0x42, 0x8c, 0xe2, 0x5e, 0x22, 0x16, 0x5b,
	0xc4, 0xbd, 0x84, 0x95, 0x35, 0x15, 0xf7, 0x12, 0xb1, 0xcc, 0xac, 0xb8, 0x97, 0xc4, 0x4a, 0xcb,
	0x12, 0xbd, 0x84, 0xc9, 0xaf, 0x8c, 0x97, 0x88, 0x22, 0x5c, 0x1f, 0x0a, 0x47, 0x86, 0x97, 0x14,
	0xa4, 0x32, 0xb3, 0x10, 0xaa, 0x94, 0x97, 0x24, 0x50, 0x29, 0x78, 0x49, 0x41, 0x43, 0x4c, 0x2f,
	0x6e, 0x52, 0x57, 0xca, 0x23, 0xe0, 0x76, 0x21, 0x89, 0x95, 0x41, 0x92, 0xbb, 0x90, 0xac, 0x92,
	0x25, 0xc9, 0x5d, 0x48, 0x66, 0x61, 0x92, 0x36, 0x82, 0xff, 0x82, 0xa0, 0x9a, 0x56, 0x2f, 0x82,
	0xeb, 0x65, 0x9d, 0x31, 0x7a, 0xe9, 0xab, 0x5e, 0x19, 0x12, 0x0b, 0xa3, 0xf5, 0xef, 0x28, 0xb1,
	0x1c, 0x8d, 0x16, 0x2a, 0xe0, 0xab, 0x65, 0x35, 0xc6, 0x57, 0x6e, 0xa8, 0x1b, 0x43, 0xe3, 0xe1,
	0x56, 0xdd, 0x19, 0xc5, 0x08, 0x92, 0xab, 0xee, 0xfc, 0xea, 0x0b, 0xc9, 0x55, 0xb7, 0x44, 0x5d,
	0x04, 0x25, 0x3a, 0xa3, 0xd2, 0x40, 0x92, 0xe8, 0xfc, 0x12, 0x07, 0x49, 0xa2, 0x25, 0x8a, 0x1e,
	0xa8, 0x1d, 0xa7, 0x55, 0x12, 0x48, 0xda, 0x71, 0x4e, 0xf1, 0x82, 0xa4, 0x1d, 0xe7, 0x95, 0x33,
	0x68, 0x23, 0xf8, 0x13, 0x04, 0xe7, 0xf2, 0xee, 0xc9, 0xf1, 0x96, 0xd4, 0x6c, 0x92, 0x45, 0x00,
	0xea, 0x4b, 0x07, 0x84, 0x8d, 0xe3, 0x21, 0xef, 0x6e, 0x5b, 0x92, 0x07, 0xc9, 0xab, 0x78, 0x49,
	0x1e, 0x64, 0x2f, 0xdc, 0xb5, 0x11, 0xfc, 0x4f, 0x56, 0x52, 0x93, 0xcd, 0xc6, 0xf5, 0x02, 0x76,
	0x2a, 0xc5, 0xc9, 0x8d, 0x83, 0x43, 0xc8, 0x29, 0x24, 0xef, 0x12, 0x5b, 0x52, 0x21, 0x92, 0x17,
	0xeb, 0x92, 0x0a, 0x91, 0xbd, 0x59, 0xd7, 0x46, 0xd6, 0xa6, 0x5f, 0x9b, 0x62, 0x70, 0x77, 0xc6,
	0xbd, 0xab, 0xaf, 0xa7, 0xfe, 0x1f, 0x00, 0x00, 0xff, 0xff, 0xc3, 0xd4, 0x57, 0x87, 0xe1, 0x4d,
	0x00, 0x00,
}
