package logging

import (
	"context"
	"net/http"

	"go.uber.org/zap"
)

var (
	// actual key is the address of this var, which is unique in program space
	loggerValue = -42
	loggerKey   = &loggerValue
)

// StoreStatsd stores a Statter in the context
func StoreLogger(stats *zap.Logger) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := storelogger(r.Context(), stats)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

func storelogger(ctx context.Context, logger *zap.Logger) context.Context {
	return context.WithValue(ctx, loggerKey, logger)
}

// LoadStatsd pulls a Statter out of the context
func LoadLogger(ctx context.Context) *zap.Logger {
	if logger, ok := ctx.Value(loggerKey).(*zap.Logger); ok {
		return logger
	}
	logger := zap.NewNop()
	return logger
}
