package model

import "code.justin.tv/gds/gds/extensions/ems/documents"

func NewCategoryDocument(category *Category, translation *CategoryTranslation) (*documents.CategoryDocument, error) {
	if translation == nil {
		// this is not an error; this can happen, for example, on category creation.
		// This way the caller doesn't have to make the fake translation for us,
		// we can just do it here.
		translation = MakeMissingCategoryTranslation()
	}
	doc := documents.CategoryDocument{
		ID:          category.ID,
		Type:        category.Type,
		Order:       category.Order,
		Slug:        category.Slug,
		SortKey:     category.SortKey,
		Readonly:    category.Readonly,
		Visible:     category.Visible,
		Deleted:     category.Deleted,
		Name:        translation.Name,
		Description: translation.Description,
	}
	return &doc, nil
}

func NewCategoriesDocument(count int, categories []*Category, translations []*CategoryTranslation) (*documents.CategoriesDocument, error) {
	if len(categories) != len(translations) {
		return nil, ErrTranslationCountMismatch
	}
	doc := documents.CategoriesDocument{
		Count:      count,
		Categories: make([]*documents.CategoryDocument, 0, len(categories)),
	}

	for i, cat := range categories {
		translation := translations[i]
		catdoc, err := NewCategoryDocument(cat, translation)
		if err != nil {
			return nil, err
		}
		doc.Categories = append(doc.Categories, catdoc)
	}

	return &doc, nil
}

func NewCategoryOrderDocument(categories []*Category) (*documents.CategoryOrderDocument, error) {
	doc := documents.CategoryOrderDocument{
		CategoryOrdering: make([]*documents.CategoryOrder, 0, len(categories)),
	}
	for _, cat := range categories {
		entry := documents.CategoryOrder{
			ID:    cat.ID,
			Order: cat.Order,
		}
		doc.CategoryOrdering = append(doc.CategoryOrdering, &entry)
	}
	return &doc, nil
}
