package model

import (
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

type Store interface {
	AddExtensionToCategory(eid, cid string, doc *documents.AddExtensionToCategoryRequest) (*CuratedCategoryExtension, error)
	CreateCategory(doc *documents.AddCategoryRequest) (*Category, error)
	DeleteCategory(cid string, softDelete bool) error
	EditCategoryTranslation(cid, lang string, doc *documents.EditCategoryTranslationRequest) (*CategoryTranslation, *Category, error)
	GetCategories(language string, offset, limit int, catType string, includeHidden, includeDeleted bool) ([]*Category, []*CategoryTranslation, int, error)
	GetCategory(cid, language string) (*Category, *CategoryTranslation, error)
	GetExtensionsForCategory(cid, sortKey string, offset, limit int) ([]*CuratedCategoryExtension, int32, error)
	OrderCategories(doc *documents.OrderCategoriesRequest) ([]*Category, error)
	OrderCategory(cid string, doc *documents.OrderCategoryRequest) (*Category, error)
	RemoveExtensionFromCategory(eid, cid string) (*CuratedCategoryExtension, error)
	UpdateCategory(cid string, doc *documents.AddCategoryRequest) (*Category, error)

	CreateFeaturedSchedule(doc *documents.AddFeaturedScheduleRequest) (*FeaturedCarouselSchedule, error)
	GetFeaturedSchedules(offset, limit int) ([]*FeaturedCarouselSchedule, int, error)
	GetFeaturedSchedule(fsid string) (*FeaturedCarouselSchedule, error)
	DeleteFeaturedSchedule(fsid string) (*FeaturedCarouselSchedule, error)
	UpdateFeaturedSchedule(fsid string, doc *documents.AddFeaturedScheduleRequest) (*FeaturedCarouselSchedule, error)

	CreateFeaturedCarousel(doc *documents.AddFeaturedCarouselRequest) (*FeaturedCarousel, error)
	GetFeaturedCarousel(fcid string) (*FeaturedCarousel, error)
	GetFeaturedCarousels(offset, limit int) ([]*FeaturedCarousel, int, error)
	DeleteFeaturedCarousel(fcid string) (*FeaturedCarousel, error)
	UpdateFeaturedCarousel(fcid string, doc *documents.AddFeaturedCarouselRequest) (*FeaturedCarousel, error)
	OrderFeaturedCarousel(fcid string, doc *documents.OrderFeaturedCarouselRequest) (*FeaturedCarousel, error)

	GetCurrentCarousel(fsid string) (*FeaturedCarousel, error)

	CreateFeaturedCarouselEntry(doc *documents.AddFeaturedCarouselEntryRequest) (*FeaturedCarouselEntry, error)
	GetFeaturedCarouselEntry(fceid string) (*FeaturedCarouselEntry, error)
	GetFeaturedCarouselEntries(offset, limit int) ([]*FeaturedCarouselEntry, int, error)
	DeleteFeaturedCarouselEntry(fceid string) (*FeaturedCarouselEntry, error)
	UpdateFeaturedCarouselEntry(fceid string, doc *documents.AddFeaturedCarouselEntryRequest) (*FeaturedCarouselEntry, error)

	GetEntriesForCarousel(fcid string) ([]*FeaturedCarouselEntry, error)

	// for test environments only
	IsResetEnabled() bool
	EnableDataReset()
	ResetAllData() error
}
