package errconv

import "context"

var (
	converterValue   = 0
	converterKey     = &converterValue
	defaultConverter = NewTypeConverter() // InternalServiceError as default
)

// Converter acts as a transform on errors, potentially decorating them
type Converter interface {
	Convert(error) error
}

// LoadConverter loads the current Converter from a Context
func LoadConverter(ctx context.Context) Converter {
	if cast, ok := ctx.Value(converterKey).(Converter); ok {
		return cast
	}
	return defaultConverter
}

// StoreConverter places a Converter into a Context
func StoreConverter(ctx context.Context, val Converter) context.Context {
	return context.WithValue(ctx, converterKey, val)
}
