package http

import (
	"context"
	"net/http"

	"code.justin.tv/extensions/instrumentation"
	"code.justin.tv/gds/gds/golibs/params"
	"github.com/jixwanwang/apiutils"
)

// unique memory address in the process, not accessible outside the package
var passThroughHackDummy int
var passThroughHackKey *int = &passThroughHackDummy

// DeprecatedCall was the original call format used by validator; all new routes
// should be using APICall format instead.
type DeprecatedCall func(r *http.Request) (interface{}, *apiutils.ErrorResponse)

// NewHandler creates an adapter around a context call and registers a hystrix
// circuit for the handler.
// DEPRECATED: use NewAPIHandler instead
func NewHandler(name string, freq instrumentation.Frequency, call DeprecatedCall) http.Handler {
	return &APIHandler{adaptDeprecatedToAPI(call), name, freq}
}

func adaptDeprecatedToAPI(call DeprecatedCall) APICall {
	return func(ctx context.Context) (interface{}, error) {
		var r *http.Request
		val := ctx.Value(passThroughHackKey)
		if val != nil {
			r1 := val.(*http.Request)
			r, _ = http.NewRequest(r1.Method, r1.URL.String(), params.New(ctx).GetBody())
			r.Header = r1.Header
		} else {
			r, _ = http.NewRequest("GET", "/", params.New(ctx).GetBody())
		}
		r = r.WithContext(ctx)

		obj, err := call(r)
		if err == nil {
			return obj, nil
		}
		return obj, *err
	}
}

// inject request information to restore them later -- this should go away with this
// format because it leaks abstraction
func withPassThroughHack(ctx context.Context, r *http.Request) context.Context {
	return context.WithValue(ctx, passThroughHackKey, r)
}
