package params

import (
	"context"
	"net/http"
)

// Extract pulls http specifc sources of data into a generic collection that
// doesn't care about specific sources.
func Extract(inner http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx := ExtractFromHTTP(r.Context(), r)
		inner.ServeHTTP(w, r.WithContext(ctx))
	})
}

// ExtractFromHTTP pulls query and body information (and the client ID, if present)
// into the request context where protocol agnostic methods can find them; first
// copy of a parameter wins
func ExtractFromHTTP(ctx context.Context, r *http.Request) context.Context {
	for name, value := range r.URL.Query() {
		if len(value) > 0 {
			ctx = Set(ctx, name, value[0])
		}
	}
	if r.Body != nil {
		ctx = SetBody(ctx, r.Body)
	}
	return ctx
}
