#!/bin/bash

status=0
RED=; GREEN=; GREYBG=; BOLD=;
case ${TERM} in
    '') ;;
    *)
        RED=$(tput setaf 1)
        GREEN=$(tput setaf 2)
        GREYBG=$(tput setab 8)
        BOLD=$(tput bold)
        RESET=$(tput sgr0)
esac

hosts_to_fake=(
    $(grep -h ' server [^{].*;' $(dirname ${0})/nginx.*.conf | awk '{$1=$1};1' | awk -F '[ ;:]' '{print $2}')
)
fake_hosts=''
for host in "${hosts_to_fake[@]}"
do
    fake_hosts="$fake_hosts --add-host $host:127.0.0.1"
done

function check_config {
    config=$(realpath $1)
    printf "%-72s" "Checking ${GREYBG}$(basename ${1})${RESET}... "
    result=$(docker run --rm -t -a stdout --name nginx -v ${config}:${config}:ro $fake_hosts nginx:alpine sh -c "apk -Uuv add openssl  > /dev/null 2>&1 && openssl req -subj '/CN=localhost' -x509 -newkey rsa:4096 -nodes -keyout /etc/nginx/key.pem -out /etc/nginx/cert.pem -days 365 > /dev/null 2>&1 && nginx -c ${config} -t")
    successful=$(echo $result | grep successful | wc -l)

    if [ $successful = 0 ]; then
        echo "${RED}${BOLD}FAILED${RESET}"
        echo "${RED}$result${RESET}"
        status=1
    else
        echo "${GREEN}${BOLD}SUCCESS${RESET}"
    fi
}

if [ -z $1 ]
then
    check_config $(dirname ${0})/nginx.local.conf
    check_config $(dirname ${0})/nginx.staging.conf
    check_config $(dirname ${0})/nginx.production.conf
else
    check_config ${1}
fi

exit $status
