// SNS topic to connect pagerduty to
resource "aws_sns_topic" "alerts" {
  name = "extensions-alerts"
}

resource "aws_sns_topic_subscription" "alerts_to_pagerduty" {
  topic_arn              = aws_sns_topic.alerts.arn
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = var.pagerduty_integration_url
}

// Alarm for too little traffic coming into orchestrator-nginx
resource "aws_cloudwatch_metric_alarm" "elb_network_packets_in_low_alarm" {
  alarm_name          = "NetworkPacketsIn-Low-Alarm"
  namespace           = "AWS/EC2"
  metric_name         = "NetworkPacketsIn"
  statistic           = "Average"
  comparison_operator = "LessThanOrEqualToThreshold"
  threshold           = var.network_packets_low_threshold
  evaluation_periods  = 1
  period              = "60"
  treat_missing_data  = "breaching"

  dimensions = {
    AutoScalingGroupName = "orchestrator-nginx-asg"
  }

  alarm_actions             = [aws_sns_topic.alerts.arn]
  ok_actions                = [aws_sns_topic.alerts.arn]
  insufficient_data_actions = [aws_sns_topic.alerts.arn]
}

// Alarm for too little traffic going out orchestrator-nginx
resource "aws_cloudwatch_metric_alarm" "elb_network_packets_out_low_alarm" {
  alarm_name          = "NetworkPacketsOut-Low-Alarm"
  namespace           = "AWS/EC2"
  metric_name         = "NetworkPacketsOut"
  statistic           = "Average"
  comparison_operator = "LessThanOrEqualToThreshold"
  threshold           = var.network_packets_low_threshold
  evaluation_periods  = 1
  period              = "60"
  treat_missing_data  = "breaching"

  dimensions = {
    AutoScalingGroupName = "orchestrator-nginx-asg"
  }

  alarm_actions             = [aws_sns_topic.alerts.arn]
  ok_actions                = [aws_sns_topic.alerts.arn]
  insufficient_data_actions = [aws_sns_topic.alerts.arn]
}