locals {
  orchestrator_service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0e429888bc88efb44"
  orchestrator_zone_name    = "twitchdxorchestrator.s.twitch.a2z.com."
}

data "aws_vpc" "internal" {
  id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_vpc_id
}

resource "aws_security_group" "orchestrator_tls_out" {
  name   = "orchestrator_tls_out"
  vpc_id = data.aws_vpc.internal.id

  ingress {
    from_port   = 443
    to_port     = 443
    protocol    = 6
    cidr_blocks = [data.aws_vpc.internal.cidr_block]
  }
}

resource "aws_vpc_endpoint" "orchestrator" {
  vpc_id            = data.aws_vpc.internal.id
  service_name      = local.orchestrator_service_name
  vpc_endpoint_type = "Interface"

  security_group_ids = [
    aws_security_group.orchestrator_tls_out.id,
  ]

  subnet_ids = data.terraform_remote_state.vpc_setup.outputs.us_west_2_private_subnets
}

resource "aws_route53_zone" "orchestrator_zone" {
  name = local.orchestrator_zone_name
  vpc {
    vpc_id = data.aws_vpc.internal.id
  }
}

resource "aws_route53_record" "orchestrator" {
  zone_id = "${aws_route53_zone.orchestrator_zone.zone_id}"
  name    = "us-west-2.beta.${aws_route53_zone.orchestrator_zone.name}"
  type    = "CNAME"
  ttl     = "300"
  records = ["${lookup(aws_vpc_endpoint.orchestrator.dns_entry[0], "dns_name")}"]
}
