variable "owner" {
  default = "twitch-extensions-orchestrator-dev@amazon.com"
}

variable "account_name" {
  default = "twitch-ext-orc-dev"
}

variable "service" {
  default = "extensions/orchestrator-nginx"
}

variable "component" {
  type    = string
  default = "orchestrator-nginx"
}

variable "environment" {
  type    = string
  default = "staging"
}

# This can be empty in dev because the lambda auto-approves deployments to all environments other than prod
variable "slack_webhook_url" {
  type        = string
  description = "The URL for your slack webhook integration, to be used by the lambda that asks you to manually approve the CodeDeploy pipeline for production"
  default     = ""
}
