variable "owner" {
  default = "twitch-ext-orchestrator-prod@amazon.com"
}

variable "account_name" {
  default = "twitch-ext-orc-prod"
}

variable "service" {
  default = "extensions/orchestrator-nginx"
}

variable "component" {
  type    = string
  default = "orchestrator-nginx"
}

variable "environment" {
  type    = string
  default = "production"
}

variable "pagerduty_integration_key" {
  description = "The Integration Key from the integration tab on the PagerDuty Service Details page for the service this component is in"

  # Low priority pages for now, since Orchestrator is still in development.
  # TODO -- replace with actual pagerduty key below:
  # default = "c018f3d49d6e4bc18b75941753dd4757"
  default = "c8cb488c2a274610a699698a9d38b6b6"
}

variable "slack_webhook_url" {
  type        = string
  description = "The URL for your slack webhook integration, to be used by the lambda that asks you to manually approve the CodeDeploy pipeline for production"
  default     = "https://hooks.slack.com/services/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"
}
