# PrivateLink

## Overview
![PrivateLink Overview](https://d1.awsstatic.com/product-marketing/PrivateLink/privatelink_how-it-works.a8ae3df6830296337b30a7c4e75d8eed403eb5d2.png)
Above is a simplified version of how PrivateLink is works in AWS (grabbed from [AWS PrivateLink Overview](https://aws.amazon.com/privatelink/#How_it_works)).

## Setting up PrivateLink in existing accounts
This is based off of the [blog](https://aws.amazon.com/blogs/networking-and-content-delivery/using-static-ip-addresses-for-application-load-balancers).

* Copy `deployments/privatelink.yaml` & `deployments/privatelink-params.json`
* Copy the variables at the top of the `Makefile`
* Copy the block of commands in `update_privatelink:`

Setup the params json file with the following parameters:
* `InternalALBDNSName`: The DNS name for the ELB (classic or application) to be linked to an NLB.
  * This can be the ElasticBeanstalk or ELB DNS name.
  * Note: The lambda function assumes the region name (i.e. `us-west-2`) is after the first period in the dns name.
    This is not true for auto-generated ElasticBeanstalk DNS names, so xxx.xxx.us-west-2.elasticbeanstalk.com will not work.
  * Example: `achoutest-env-2.us-west-2.elasticbeanstalk.com
* `Environment`: The environment this will be setup for.
  * Example: `staging`, `production`
* `AppName`: The application name this will be setup for.
  * Example: `achoutest`
* `VPC`: The VPC the targets of the NLB TargetGroup is located in.
* `SubnetA`, `SubnetB`, `SubnetC`: Subnets the NLB should be associated with.

## Adding a VPC endpoint to a PrivateLink account
Note: If your service was setup with stepladder, this Cloudformation stack can be
nested in the global service stack. An example of this can be found [here](https://git-aws.internal.justin.tv/vod/tailor/blob/master/deployments/service.yaml#L101)

* Copy `deployments/vpcendpoint.yaml` & `deployments/vpcendpoint-params.json`
* Copy the variables at the top of the `Makefile`
* Copy the block of commands in `update_vpcendpoint:`

Setup the params json file with the following parameters:
* `VPC`: The VPC the VPC endpoint is located in.
* `SubnetA`, `SubnetB`, `SubnetC`: Subnets the VPC endpoint should be associated with.
* `SecurityGroup`: Security group the VPC endpoint is associated with.
