package shutdown

import "sort"

// entry for manager shutdown
type entry struct {
	key   interface{}
	hook  Hook
	order int
}

type entries []*entry

var _ sort.Interface = (entries)(nil)

func (e entries) Len() int           { return len(e) }
func (e entries) Less(i, j int) bool { return e[i].order > e[j].order } // highest first
func (e entries) Swap(i, j int)      { e[i], e[j] = e[j], e[i] }
