provider "aws" {
  region = "us-west-2"
  version = "~> 1.17"
}

module "base_vpc" {
  source = "./modules/base_vpc"

  vpc_cidr = "10.203.176.0/22"
  private_subnets = ["10.203.176.0/26","10.203.176.64/26","10.203.176.128/26"]
  public_subnets = ["10.203.177.0/26","10.203.177.64/26","10.203.177.128/26"]
  elasticache_subnets = ["10.203.178.0/26","10.203.178.64/26","10.203.178.128/26"]
}

module "datadog_integration" {
  source = "./modules/datadog_integration"
}

module "ecs_registry" {
  source = "./modules/ecs_registry"
}

module "memcached" {
  source = "./modules/memcache"

  vpc_id = "${module.base_vpc.vpc_id}"
  cluster_sg = "memcache-group-${module.base_vpc.cluster_name}"
  cluster_subnet_hostgroup = "${module.base_vpc.elasticache_subnet_hostgroup_name}"
  cluster_name = "smart-${module.base_vpc.cluster_name}"
  root_zone_id = "${module.route53.root_zone_id}"
  vpc_cidr = "${module.base_vpc.cidr_block}"
}

module "route53" {
  source = "./modules/route53"

  dns_zone_root_name = "prod.smart.extensions.twitch.a2z.com."
}

module "twitch_chat_link" {
  source = "./modules/twitch_chat_link"

  dns_root_zone_id = "${module.route53.root_zone_id}"
  twitch_chat_dev_endpoint = "internal-pubsub-broker-darklaunch-1635774229.us-west-2.elb.amazonaws.com"
  twitch_chat_prod_endpoint = "internal-pubsub-production-internal-1513809412.us-west-2.elb.amazonaws.com"
}

module "validator_link" {
  source = "./modules/validator_link"

  vpc_id = "${module.base_vpc.vpc_id}"
  root_zone_id = "${module.route53.root_zone_id}"
  private_subnet_cidrs = "${module.base_vpc.private_subnet_cidrs}"
  private_subnet_ids = "${module.base_vpc.private_subnet_ids}"
  public_subnet_cidrs = "${module.base_vpc.public_subnet_cidrs}"
  public_subnet_ids = "${module.base_vpc.public_subnet_ids}"
}

module "visage_link" {
  source = "./modules/visage_link"

  root_dns_zone_id = "${module.route53.root_zone_id}"
}

module "vpc_service_endpoint" {
  source = "./modules/vpc_service_endpoint"
}
