
module "vpc" {
  source  = "terraform-aws-modules/vpc/aws"
  version = "1.31.0"

  name    = "${var.cluster_name}"
  cidr    = "${var.vpc_cidr}"

  azs     = "${var.cluster_azs}"
  public_subnets  = "${var.public_subnets}"
  private_subnets = "${var.private_subnets}"
  elasticache_subnets = "${var.elasticache_subnets}"

  private_subnet_tags = {
    "kubernetes.io/cluster/${var.cluster_name}.${var.cluster_domain}" = "shared"
    "kubernetes.io/role/internal-elb" = "1"
    "SubnetType" = "Private"
  }
  public_subnet_tags = {
    "kubernetes.io/cluster/${var.cluster_name}.${var.cluster_domain}" = "shared"
    "kubernetes.io/role/elb" = "1"
    "SubnetType" = "Utility"
  }

  enable_dns_hostnames  = true
  enable_nat_gateway    = true
  propagate_private_route_tables_vgw = true
  propagate_public_route_tables_vgw = true

  tags = {
    Environment = "${var.environment_name}"
    Name        = "${var.cluster_name}"
    Terraform   = "True"
    datadog     = "true"
  }
}
