# VPC
output "vpc_id" {
  description = "The ID of the VPC"
  value       = "${module.vpc.vpc_id}"
}

# Addressing
output "cidr_block" {
  value = "${var.vpc_cidr}"
}

output "private_subnet_ids" {
  value = "${module.vpc.private_subnets}"
}

output "public_subnet_ids" {
  value = "${module.vpc.public_subnets}"
}

output "private_subnet_cidrs" {
  value = "${module.vpc.private_subnets_cidr_blocks}"
}

output "public_subnet_cidrs" {
  value = "${module.vpc.public_subnets_cidr_blocks}"
}

output "elasticache_subnet_hostgroup_name" {
  value = "${module.vpc.elasticache_subnet_group_name}"
}

# Regionality
output "availability_zones" {
  value = "${var.cluster_azs}"
}

output "region" {
  value = "${var.cluster_region}"
}

output "cluster_name" {
  value = "${var.cluster_name}"
}