
resource "aws_security_group" "memcache-group"{
  name = "${var.cluster_sg}"
  description = "Allow ingress over 11211 for Elasticache memcached"
  vpc_id = "${var.vpc_id}"

  ingress {
    from_port = 11211
    protocol = "TCP"
    to_port = 11211
    cidr_blocks = ["${var.vpc_cidr}"]
  }

  egress {
    from_port = 0
    protocol = "-1"
    to_port = 0
    cidr_blocks = ["${var.vpc_cidr}"]
  }
}

resource "aws_elasticache_cluster" "smart-memcached" {
  cluster_id = "${var.cluster_name}"
  engine = "memcached"
  node_type = "cache.m3.medium"
  num_cache_nodes = 2
  parameter_group_name = "default.memcached1.4"
  port = 11211
  subnet_group_name = "${var.cluster_subnet_hostgroup}"
  security_group_ids = ["${aws_security_group.memcache-group.id}"]
  az_mode = "cross-az"
}

resource "aws_route53_record" "smart-memcache-endpoint" {
  name = "smart-memcache-endpoint"
  type = "CNAME"
  zone_id = "${var.root_zone_id}"
  ttl = 60
  records = ["${aws_elasticache_cluster.smart-memcached.cluster_address}"]
}
